/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.config.FlagLootCondition;
import org.violetmoon.zeta.config.SyncedFlagHandler;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaModule;

public final class ConfigFlagManager {
    public final Zeta zeta;
    private final Set<String> allFlags = new HashSet<String>();
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();
    public static final LootItemConditionType FLAG_CONDITION_TYPE = new LootItemConditionType(FlagLootCondition.CODEC);

    public ConfigFlagManager(Zeta zeta) {
        this.zeta = zeta;
        zeta.loadBus.subscribe(this);
    }

    @LoadEvent
    public void onRegister(ZRegister event) {
        SyncedFlagHandler.setupFlagManager(this);
    }

    public void clear() {
        this.flags.clear();
    }

    public void putFlag(ZetaModule module, String flag, boolean value) {
        this.flags.put(flag, value && module.isEnabled());
        if (!this.allFlags.contains(flag)) {
            this.allFlags.add(flag);
        }
    }

    public void putModuleFlag(ZetaModule module) {
        this.putFlag(module, module.lowerCaseName(), true);
    }

    public boolean isValidFlag(String flag) {
        return this.flags.containsKey(flag);
    }

    public boolean getFlag(String flag) {
        Boolean obj = this.flags.get(flag);
        return obj != null && obj != false;
    }

    public Set<String> getAllFlags() {
        return this.allFlags;
    }
}

