/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.violetmoon.zeta.block.ext.IZetaBlockExtensions;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.registry.CreativeTabManager;

public interface IZetaBlock
extends IZetaBlockExtensions,
IDisableable<IZetaBlock> {
    default public Block getBlock() {
        return (Block)this;
    }

    default public Block setCreativeTab(ResourceKey<CreativeModeTab> tab) {
        Block b = this.getBlock();
        CreativeTabManager.addToTab(tab, (ItemLike)b);
        return b;
    }

    default public Block setCreativeTab(ResourceKey<CreativeModeTab> tab, ItemLike parent, boolean behindParent) {
        Block b = this.getBlock();
        CreativeTabManager.addNextToItem(tab, (ItemLike)b, parent, behindParent);
        return b;
    }

    @Override
    default public int getFlammabilityZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.getValues().containsKey(BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return 0;
        }
        SoundType totallyMaterialTrustMeImADolphin = state.getSoundType();
        if (totallyMaterialTrustMeImADolphin == SoundType.WOOL) {
            return 60;
        }
        if (totallyMaterialTrustMeImADolphin == SoundType.WOOD || state.ignitedByLava()) {
            return 20;
        }
        ResourceLocation loc = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (loc != null && (loc.getPath().endsWith("_log") || loc.getPath().endsWith("_wood"))) {
            return 5;
        }
        return 0;
    }

    @Override
    default public int getFireSpreadSpeedZeta(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (state.getValues().containsKey(BlockStateProperties.WATERLOGGED) && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            return 0;
        }
        SoundType gaming = state.getSoundType();
        if (gaming == SoundType.WOOL) {
            return 30;
        }
        if (gaming == SoundType.WOOD || state.ignitedByLava()) {
            return 5;
        }
        return 0;
    }
}

