/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.violetmoon.zeta.mixin.mixins.AccessorBlock;
import org.violetmoon.zeta.mixin.mixins.AccessorItem;

public class NameChanger {
    protected static Map<Block, String> originalBlockNames = new IdentityHashMap<Block, String>();
    protected static Map<Block, NameChangeRequests> changedBlockNames = new IdentityHashMap<Block, NameChangeRequests>();
    protected static Map<Item, String> originalItemNames = new IdentityHashMap<Item, String>();
    protected static Map<Item, NameChangeRequests> changedItemNames = new IdentityHashMap<Item, NameChangeRequests>();

    public void changeBlock(Block toChange, String newTranslationKey, boolean enabled) {
        NameChanger.changeBlockStatic(toChange, newTranslationKey, enabled);
    }

    public void changeItem(Item toChange, String newTranslationKey, boolean enabled) {
        NameChanger.changeItemStatic(toChange, newTranslationKey, enabled);
    }

    protected static synchronized void changeBlockStatic(Block toChange, String newTranslationKey, boolean enabled) {
        originalBlockNames.computeIfAbsent(toChange, Block::getDescriptionId);
        NameChangeRequests changeRequests = changedBlockNames.computeIfAbsent(toChange, __ -> new NameChangeRequests());
        if (enabled) {
            changeRequests.add(newTranslationKey);
        } else {
            changeRequests.remove(newTranslationKey);
        }
        ((AccessorBlock)toChange).zeta$setDescriptionID(changeRequests.lastOrElse(originalBlockNames.get(toChange)));
        if (changeRequests.isEmpty()) {
            changedBlockNames.remove(toChange);
        }
    }

    protected static synchronized void changeItemStatic(Item toChange, String newTranslationKey, boolean enabled) {
        originalItemNames.computeIfAbsent(toChange, Item::getDescriptionId);
        NameChangeRequests changeRequests = changedItemNames.computeIfAbsent(toChange, __ -> new NameChangeRequests());
        if (enabled) {
            changeRequests.add(newTranslationKey);
        } else {
            changeRequests.remove(newTranslationKey);
        }
        ((AccessorItem)toChange).zeta$setDescriptionID(changeRequests.lastOrElse(originalItemNames.get(toChange)));
        if (changeRequests.isEmpty()) {
            changedItemNames.remove(toChange);
        }
    }

    protected static class NameChangeRequests {
        List<String> list = new ArrayList<String>(1);

        protected NameChangeRequests() {
        }

        public void add(String value) {
            this.remove(value);
            this.list.add(value);
        }

        public void remove(String value) {
            this.list.remove(value);
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public String lastOrElse(String orElse) {
            return this.list.isEmpty() ? orElse : this.list.getLast();
        }
    }
}

