/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.module;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.violetmoon.zeta.Zeta;
import org.violetmoon.zeta.module.ModuleFinder;
import org.violetmoon.zeta.module.ModuleInstance;
import org.violetmoon.zeta.module.TentativeModule;
import org.violetmoon.zeta.module.ZetaCategory;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.ZetaSide;
import org.violetmoon.zetaimplforge.event.load.ForgeZModulesReady;

public class ZetaModuleManager {
    private final Zeta z;
    private final Map<Class<? extends ZetaModule>, ZetaModule> modulesByKey = new LinkedHashMap<Class<? extends ZetaModule>, ZetaModule>();
    private final Map<String, ZetaCategory> categoriesById = new LinkedHashMap<String, ZetaCategory>();
    private final Map<ZetaCategory, List<ZetaModule>> modulesInCategory = new HashMap<ZetaCategory, List<ZetaModule>>();

    public ZetaModuleManager(Zeta z) {
        this.z = z;
    }

    public Collection<ZetaModule> getModules() {
        return this.modulesByKey.values();
    }

    public <M extends ZetaModule> M get(Class<M> keyClass) {
        return (M)this.modulesByKey.get(keyClass);
    }

    public <M extends ZetaModule> Optional<M> getOptional(Class<M> keyClass) {
        return Optional.ofNullable(this.get(keyClass));
    }

    public boolean isEnabled(Class<? extends ZetaModule> keyClass) {
        return this.get(keyClass).isEnabled();
    }

    public boolean isEnabledOrOverlapping(Class<? extends ZetaModule> keyClass) {
        ZetaModule module = this.get(keyClass);
        return module.isEnabled() || module.disabledByOverlap();
    }

    public ZetaCategory getCategory(String id) {
        if (id == null || id.isEmpty()) {
            id = "Unknown";
        }
        return this.categoriesById.computeIfAbsent(id, ZetaCategory::unknownCategory);
    }

    public Collection<ZetaCategory> getCategories() {
        return this.categoriesById.values();
    }

    public List<ZetaCategory> getInhabitedCategories() {
        return this.categoriesById.values().stream().filter(c -> !this.modulesInCategory((ZetaCategory)c).isEmpty()).toList();
    }

    public List<ZetaModule> modulesInCategory(ZetaCategory cat) {
        return this.modulesInCategory.computeIfAbsent(cat, __ -> new ArrayList());
    }

    public void initCategories(Iterable<ZetaCategory> cats) {
        for (ZetaCategory cat : cats) {
            this.categoriesById.put(cat.name, cat);
        }
    }

    public void load(ModuleFinder finder) {
        Collection<TentativeModule> tentative = ((Stream)finder.get()).map(data -> TentativeModule.from(data, this::getCategory)).filter(tm -> tm.appliesTo(this.z.side)).sorted(Comparator.comparing(TentativeModule::loadPhase).thenComparing(TentativeModule::displayName)).toList();
        if (this.z.side == ZetaSide.CLIENT) {
            LinkedHashMap<Class<? extends ZetaModule>, TentativeModule> byClazz = new LinkedHashMap<Class<? extends ZetaModule>, TentativeModule>();
            for (TentativeModule tm2 : tentative) {
                if (tm2.clientReplacement()) continue;
                byClazz.put(tm2.clazz(), tm2);
            }
            for (TentativeModule tm2 : tentative) {
                if (!tm2.clientReplacement()) continue;
                Class<? extends ZetaModule> superclass = tm2.clazz().getSuperclass();
                TentativeModule existing = (TentativeModule)byClazz.get(superclass);
                if (existing == null) {
                    throw new RuntimeException("Module " + tm2.clazz().getName() + " wants to replace " + superclass.getName() + ", but that module isn't registered");
                }
                byClazz.put(superclass, existing.replaceWith(tm2));
            }
            tentative = byClazz.values();
        }
        this.z.log.info("Discovered " + tentative.size() + " modules to load.");
        for (TentativeModule t : tentative) {
            this.modulesByKey.put(t.keyClass(), this.constructAndSetup(t));
        }
        this.z.log.info("Constructed {} modules.", (Object)this.modulesByKey.size());
        this.z.loadBus.fire(new ForgeZModulesReady());
    }

    public void doFinalize() {
        for (ZetaModule m : this.getModules()) {
            m.finalized = true;
            m.updateBusSubscriptions(this.z);
        }
    }

    private ZetaModule constructAndSetup(TentativeModule t) {
        this.z.log.info("Constructing module {}...", (Object)t.displayName());
        ZetaModule module = this.construct(t.clazz());
        module.zeta = this.z;
        module.category = t.category();
        module.displayName = t.displayName();
        module.lowercaseName = t.lowercaseName();
        module.description = t.description();
        module.antiOverlap = t.antiOverlap();
        module.enabledByDefault = t.enabledByDefault();
        module.setEnabled(this.z, t.enabledByDefault());
        this.z.loadBus.subscribe(module.getClass()).subscribe(module);
        this.modulesInCategory.computeIfAbsent(module.category, __ -> new ArrayList()).add(module);
        ZetaModuleManager.populateModuleInstanceField(module);
        module.postConstruct();
        return module;
    }

    private static void populateModuleInstanceField(ZetaModule module) {
        ZetaLoadModule annotation;
        Class<?> clazz = module.getClass();
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (module.getClass().isAnnotationPresent(ZetaLoadModule.class) && (annotation = module.getClass().getAnnotation(ZetaLoadModule.class)).clientReplacement()) {
            fields.addAll(Arrays.asList(clazz.getSuperclass().getDeclaredFields()));
        }
        ArrayList<Field> targetFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ModuleInstance.class)) continue;
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new IllegalStateException("@ModuleInstance annotated field must be static");
            }
            if (!field.getType().isAssignableFrom(clazz)) {
                throw new IllegalStateException("@ModuleInstance annotated field must be assignable from the module class. Expected: " + field.getType() + ", got: " + clazz);
            }
            targetFields.add(field);
        }
        for (Field targetField : targetFields) {
            targetField.setAccessible(true);
            try {
                targetField.set(null, module);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <Z extends ZetaModule> Z construct(Class<Z> clazz) {
        try {
            Constructor<Z> cons = clazz.getConstructor(new Class[0]);
            return (Z)((ZetaModule)cons.newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not construct ZetaModule '" + clazz.getName() + "', does it have a public zero-argument constructor?", e);
        }
    }
}

