/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import org.violetmoon.zeta.config.ZetaGeneralConfig;
import org.violetmoon.zeta.mod.ZetaMod;
import org.violetmoon.zeta.module.IDisableable;

public class CreativeTabManager {
    private static final Object MUTEX = new Object();
    private static final Map<ItemLike, Item> itemLikeCache = new HashMap<ItemLike, Item>();
    private static final Map<ResourceKey<CreativeModeTab>, CreativeTabAdditions> additions = new HashMap<ResourceKey<CreativeModeTab>, CreativeTabAdditions>();
    private static final Multimap<ItemLike, ResourceKey<CreativeModeTab>> mappedItems = HashMultimap.create();
    private static boolean daisyChainMode = false;
    private static ItemSet daisyChainedSet = null;

    public static void daisyChain() {
        daisyChainMode = true;
        daisyChainedSet = null;
    }

    public static void endDaisyChain() {
        daisyChainMode = false;
        daisyChainedSet = null;
    }

    public static void addToCreativeTab(ResourceKey<CreativeModeTab> tab, ItemLike item) {
        if (daisyChainMode) {
            if (daisyChainedSet == null) {
                throw new IllegalArgumentException("Must start daisy chain with addToCreativeTabNextTo");
            }
            CreativeTabManager.addToDaisyChain(item);
        } else {
            CreativeTabManager.getForTab(tab).appendToEnd.add(item);
        }
        mappedItems.put((Object)item, tab);
    }

    public static void addToCreativeTabNextTo(ResourceKey<CreativeModeTab> tab, ItemLike item, ItemLike target, boolean behind) {
        tab = CreativeTabManager.guessTab(target, tab);
        CreativeTabAdditions additions = CreativeTabManager.getForTab(tab);
        Map<ItemSet, ItemLike> map = behind ? additions.appendBehind : additions.appendInFront;
        ItemSet toAdd = null;
        if (daisyChainMode) {
            boolean newSet = daisyChainedSet == null;
            ItemSet set = CreativeTabManager.addToDaisyChain(item);
            if (newSet) {
                toAdd = set;
            }
        } else {
            toAdd = new ItemSet(item);
        }
        if (toAdd != null) {
            map.put(toAdd, target);
        }
        mappedItems.put((Object)item, tab);
    }

    private static ItemSet addToDaisyChain(ItemLike item) {
        if (daisyChainMode && daisyChainedSet != null) {
            CreativeTabManager.daisyChainedSet.items.add(item);
            return daisyChainedSet;
        }
        ItemSet set = new ItemSet(item);
        if (daisyChainMode) {
            daisyChainedSet = set;
        }
        return set;
    }

    private static ResourceKey<CreativeModeTab> guessTab(ItemLike parent, ResourceKey<CreativeModeTab> tab) {
        if (parent != null && mappedItems.containsKey((Object)parent)) {
            tab = (ResourceKey)mappedItems.get((Object)parent).iterator().next();
        }
        return tab;
    }

    private static CreativeTabAdditions getForTab(ResourceKey<CreativeModeTab> tab) {
        return additions.computeIfAbsent(tab, tabRk -> new CreativeTabAdditions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildContents(BuildCreativeModeTabContentsEvent event) {
        Object object = MUTEX;
        synchronized (object) {
            ResourceKey tabKey = event.getTabKey();
            MutableHashedLinkedMap entries = event.getEntries();
            if (additions.containsKey(tabKey)) {
                CreativeTabAdditions add = additions.get(tabKey);
                for (ItemLike item : add.appendToEnd) {
                    CreativeTabManager.acceptItem(event, item);
                }
                if (ZetaGeneralConfig.forceCreativeTabAppends) {
                    for (ItemSet itemset : add.appendInFront.keySet()) {
                        for (ItemLike item : itemset.items) {
                            CreativeTabManager.acceptItem(event, item);
                        }
                    }
                    for (ItemSet itemset : add.appendBehind.keySet()) {
                        for (ItemLike item : itemset.items) {
                            CreativeTabManager.acceptItem(event, item);
                        }
                    }
                    return;
                }
                LinkedHashMap<ItemSet, ItemLike> front = new LinkedHashMap<ItemSet, ItemLike>(add.appendInFront);
                LinkedHashMap<ItemSet, ItemLike> behind = new LinkedHashMap<ItemSet, ItemLike>(add.appendBehind);
                int failsafe = 100;
                int printThreshold = 90;
                int misses = 0;
                boolean failsafing = false;
                do {
                    boolean missed = false;
                    CreativeTabManager.logVerbose(() -> "front empty=" + front.isEmpty() + " / behind empty=" + behind.isEmpty());
                    if (entries.isEmpty()) {
                        ZetaMod.LOGGER.error("entries map for tab " + tabKey + " is empty, this should never happen");
                        return;
                    }
                    if (!front.isEmpty()) {
                        missed = CreativeTabManager.appendNextTo((ResourceKey<CreativeModeTab>)tabKey, (MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, front, false, failsafing);
                    }
                    if (!behind.isEmpty()) {
                        missed |= CreativeTabManager.appendNextTo((ResourceKey<CreativeModeTab>)tabKey, (MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, behind, true, failsafing);
                    }
                    if (missed) {
                        int fMisses = misses++;
                        CreativeTabManager.logVerbose(() -> "Missed " + fMisses + "times out of 100");
                    }
                    if (misses > 100) {
                        CreativeTabManager.logVerbose(() -> {
                            StringBuilder sb = new StringBuilder();
                            for (Map.Entry entry : entries) {
                                sb.append(entry.getKey());
                                sb.append("; ");
                            }
                            return sb.toString();
                        });
                        new RuntimeException("Creative tab placement misses exceeded failsafe, aborting logic").printStackTrace();
                        return;
                    }
                    if (misses <= 90) continue;
                    failsafing = true;
                } while (!front.isEmpty() || !behind.isEmpty());
                return;
            }
        }
    }

    private static boolean isItemEnabled(ItemLike item) {
        if (item instanceof IDisableable) {
            IDisableable id = (IDisableable)item;
            return id.isEnabled();
        }
        return true;
    }

    private static void acceptItem(BuildCreativeModeTabContentsEvent event, ItemLike item) {
        if (!CreativeTabManager.isItemEnabled(item)) {
            return;
        }
        if (item instanceof AppendsUniquely) {
            AppendsUniquely au = (AppendsUniquely)item;
            event.m_246601_(au.appendItemsToCreativeTab());
        } else {
            event.m_246326_(item);
        }
    }

    private static void addToEntries(ItemStack target, MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike item, boolean behind) {
        CreativeTabManager.logVerbose(() -> "adding target=" + target + " next to " + item + " with behind=" + behind);
        if (!CreativeTabManager.isItemEnabled(item)) {
            return;
        }
        List<ItemStack> stacksToAdd = Arrays.asList(new ItemStack(item));
        if (item instanceof AppendsUniquely) {
            AppendsUniquely au = (AppendsUniquely)item;
            stacksToAdd = au.appendItemsToCreativeTab();
        }
        if (!behind) {
            Collections.reverse(stacksToAdd);
        }
        for (ItemStack addStack : stacksToAdd) {
            if (behind) {
                entries.putBefore((Object)target, (Object)addStack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                continue;
            }
            entries.putAfter((Object)target, (Object)addStack, (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private static boolean appendNextTo(ResourceKey<CreativeModeTab> tabKey, MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, Map<ItemSet, ItemLike> map, boolean behind, boolean log) {
        CreativeTabManager.logVerbose(() -> "appendNextTo " + tabKey + " / behind=" + behind);
        Set<ItemSet> coll = map.keySet();
        if (coll.isEmpty()) {
            throw new RuntimeException("Tab collection is empty, this should never happen.");
        }
        ItemSet firstSet = (ItemSet)coll.iterator().next();
        ItemLike firstSetItem = firstSet.items.get(0);
        ItemLike target = map.get(firstSet);
        CreativeTabManager.logVerbose(() -> "target is " + target);
        if (log) {
            ZetaMod.LOGGER.error("Creative tab loop found when adding {} next to {}", (Object)firstSetItem, (Object)target);
            ZetaMod.LOGGER.error("For more info enable Creative Verbose Logging in the Zeta config, or set Force Creative Tab Appends to true to disable this behavior");
        }
        map.remove(firstSet);
        if (!CreativeTabManager.isItemEnabled(firstSetItem) || target == null) {
            CreativeTabManager.logVerbose(() -> "hit early false return");
            return false;
        }
        if (!itemLikeCache.containsKey(target)) {
            itemLikeCache.put(target, target.m_5456_());
        }
        Item targetItem = itemLikeCache.get(target);
        for (Map.Entry entry : entries) {
            ItemStack stack = (ItemStack)entry.getKey();
            Item item = stack.m_41720_();
            CreativeTabManager.logVerbose(() -> "Comparing item " + item + " to our target " + targetItem);
            if (item != targetItem) continue;
            CreativeTabManager.logVerbose(() -> "Matched! Adding successfully");
            for (int i = 0; i < firstSet.items.size(); ++i) {
                int j = i;
                if (!behind) {
                    j = firstSet.items.size() - 1 - i;
                }
                CreativeTabManager.addToEntries(stack, entries, firstSet.items.get(j), behind);
            }
            return false;
        }
        map.put(firstSet, target);
        return true;
    }

    private static void logVerbose(Supplier<String> s) {
        if (ZetaGeneralConfig.enableCreativeVerboseLogging) {
            ZetaMod.LOGGER.warn(s.get());
        }
    }

    private static class ItemSet {
        List<ItemLike> items = new ArrayList<ItemLike>();

        public ItemSet(ItemLike item) {
            this.items.add(item);
        }
    }

    private static class CreativeTabAdditions {
        private List<ItemLike> appendToEnd = new ArrayList<ItemLike>();
        private Map<ItemSet, ItemLike> appendInFront = new LinkedHashMap<ItemSet, ItemLike>();
        private Map<ItemSet, ItemLike> appendBehind = new LinkedHashMap<ItemSet, ItemLike>();

        private CreativeTabAdditions() {
        }
    }

    public static interface AppendsUniquely
    extends ItemLike {
        public List<ItemStack> appendItemsToCreativeTab();
    }
}

