/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block.be;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ZetaBlockEntity
extends BlockEntity {
    public ZetaBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.writeSharedNBT(tag, provider);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.readSharedNBT(tag, provider);
    }

    public void writeSharedNBT(CompoundTag cmp, HolderLookup.Provider provider) {
    }

    public void readSharedNBT(CompoundTag cmp, HolderLookup.Provider provider) {
    }

    public void sync() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            slevel.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.writeSharedNBT(tag, provider);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        super.onDataPacket(net, packet, provider);
        this.readSharedNBT(packet.getTag(), provider);
    }
}

