/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.Zeta;

public abstract class BrewingRegistry {
    protected final Zeta zeta;
    protected final Map<Potion, String> modPotionsToConfigFlag = Maps.newHashMap();

    public BrewingRegistry(Zeta zeta) {
        this.zeta = zeta;
    }

    public void addPotionMix(String flag, Item reagent, MobEffect effect) {
        this.addPotionMix(flag, reagent, effect, null);
    }

    public void addPotionMix(String flag, Item reagent, MobEffect effect, int normalTime, int longTime, int strongTime) {
        this.addPotionMix(flag, reagent, effect, null, normalTime, longTime, strongTime);
    }

    public void addPotionMix(String flag, Item reagent, MobEffect effect, @Nullable MobEffect negation) {
        this.addPotionMix(flag, reagent, effect, negation, 3600, 9600, 1800);
    }

    public void addPotionMix(String flag, Item reagent, MobEffect effect, @Nullable MobEffect negation, int normalTime, int longTime, int strongTime) {
        ResourceLocation loc = this.zeta.registry.getRegistryName(effect, BuiltInRegistries.MOB_EFFECT);
        if (loc != null) {
            ResourceLocation negationLoc;
            String baseName = loc.getPath();
            boolean hasStrong = strongTime > 0;
            Holder effectHolder = Holder.direct((Object)effect);
            Potion normalType = this.registerPotion(new MobEffectInstance(effectHolder, normalTime), baseName, baseName);
            Potion longType = this.registerPotion(new MobEffectInstance(effectHolder, longTime), baseName, "long_" + baseName);
            Potion strongType = !hasStrong ? null : this.registerPotion(new MobEffectInstance(effectHolder, strongTime, 1), baseName, "strong_" + baseName);
            this.addPotionMix(flag, reagent, normalType, longType, strongType);
            if (negation != null && (negationLoc = this.zeta.registry.getRegistryName(negation, BuiltInRegistries.MOB_EFFECT)) != null) {
                String negationBaseName = negationLoc.getPath();
                Holder negationHolder = Holder.direct((Object)negation);
                Potion normalNegationType = this.registerPotion(new MobEffectInstance(negationHolder, normalTime), negationBaseName, negationBaseName);
                Potion longNegationType = this.registerPotion(new MobEffectInstance(negationHolder, longTime), negationBaseName, "long_" + negationBaseName);
                Potion strongNegationType = !hasStrong ? null : this.registerPotion(new MobEffectInstance(negationHolder, strongTime, 1), negationBaseName, "strong_" + negationBaseName);
                this.addNegation(flag, normalType, longType, strongType, normalNegationType, longNegationType, strongNegationType);
            }
        }
    }

    public void addPotionMix(String flag, Item reagent, Potion normalType, Potion longType, @Nullable Potion strongType) {
        boolean hasStrong = strongType != null;
        this.addFlaggedRecipe(flag, (Potion)Potions.AWKWARD.value(), reagent, normalType);
        this.addFlaggedRecipe(flag, (Potion)Potions.WATER.value(), reagent, (Potion)Potions.MUNDANE.value());
        if (hasStrong) {
            this.addFlaggedRecipe(flag, normalType, Items.GLOWSTONE, strongType);
        }
        this.addFlaggedRecipe(flag, normalType, Items.REDSTONE, longType);
    }

    public void addNegation(String flag, Potion normalType, Potion longType, @Nullable Potion strongType, Potion normalNegatedType, Potion longNegatedType, @Nullable Potion strongNegatedType) {
        boolean hasStrong;
        this.addFlaggedRecipe(flag, normalType, Items.FERMENTED_SPIDER_EYE, normalNegatedType);
        boolean bl = hasStrong = strongType != null && strongNegatedType != null;
        if (hasStrong) {
            this.addFlaggedRecipe(flag, strongType, Items.FERMENTED_SPIDER_EYE, strongNegatedType);
            this.addFlaggedRecipe(flag, normalNegatedType, Items.GLOWSTONE_DUST, strongNegatedType);
        }
        this.addFlaggedRecipe(flag, longType, Items.FERMENTED_SPIDER_EYE, longNegatedType);
        this.addFlaggedRecipe(flag, normalNegatedType, Items.REDSTONE, longNegatedType);
    }

    protected void addFlaggedRecipe(String flag, Potion potion, Item reagent, Potion to) {
        this.modPotionsToConfigFlag.put(to, flag);
        if (this.zeta.configManager.getConfigFlagManager().getFlag(flag)) {
            this.addBrewingRecipe(potion, reagent, to);
        }
    }

    protected Potion registerPotion(MobEffectInstance eff, String baseName, String name) {
        Potion effect = new Potion(this.zeta.modid + "." + baseName, new MobEffectInstance[]{eff});
        this.zeta.registry.register(effect, name, Registries.POTION);
        this.modPotionsToConfigFlag.put(effect, name);
        return effect;
    }

    public boolean isEnabled(Potion potion) {
        return !this.modPotionsToConfigFlag.containsKey(potion) || this.zeta.configManager.getConfigFlagManager().getFlag(this.modPotionsToConfigFlag.get(potion));
    }

    protected abstract void addBrewingRecipe(Potion var1, Item var2, Potion var3);
}

