/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util.handler;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.apache.commons.lang3.tuple.Pair;
import org.violetmoon.zeta.advancement.modifier.WaxModifier;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.play.ZBlock;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaModule;

public final class ToolInteractionHandler {
    private static final Map<Block, Block> cleanToWaxMap = HashBiMap.create();
    private static final List<BooleanPropertyWaxableBlock> booleanPropertySet = new ArrayList<BooleanPropertyWaxableBlock>();
    private static final Map<ItemAbility, Map<Block, Block>> interactionMaps = new HashMap<ItemAbility, Map<Block, Block>>();
    private static final Multimap<ZetaModule, Pair<Block, Block>> waxingByModule = HashMultimap.create();

    public static void registerWaxedBlock(ZetaModule module, Block clean, Block waxed) {
        cleanToWaxMap.put(clean, waxed);
        ToolInteractionHandler.registerInteraction(ItemAbilities.AXE_WAX_OFF, waxed, clean);
        waxingByModule.put((Object)module, (Object)Pair.of((Object)clean, (Object)waxed));
    }

    public static void registerWaxedBlockBooleanProperty(ZetaModule module, Block block, BooleanProperty property) {
        BooleanPropertyWaxableBlock booleanPropertyWaxableBlock = new BooleanPropertyWaxableBlock(module, block, property, ItemAbilities.AXE_WAX_OFF);
        booleanPropertySet.add(booleanPropertyWaxableBlock);
        waxingByModule.put((Object)module, (Object)Pair.of((Object)block, (Object)block));
    }

    public static void registerInteraction(ItemAbility ability, Block in, Block out) {
        if (!interactionMaps.containsKey(ability)) {
            interactionMaps.put(ability, new HashMap());
        }
        Map<Block, Block> map = interactionMaps.get(ability);
        map.put(in, out);
    }

    @LoadEvent
    public static void addModifiers(ZCommonSetup event) {
        event.enqueueWork(() -> {
            for (ZetaModule module : waxingByModule.keySet()) {
                Collection pairs = waxingByModule.get((Object)module);
                HashSet<Block> unwaxed = new HashSet<Block>();
                HashSet<Block> waxed = new HashSet<Block>();
                for (Pair pair : pairs) {
                    unwaxed.add((Block)pair.getLeft());
                    waxed.add((Block)pair.getRight());
                }
                module.zeta().advancementModifierRegistry.addModifier(new WaxModifier(module, unwaxed, waxed));
            }
        });
    }

    @PlayEvent
    public static void itemAbilityEvent(ZBlock.BlockToolModification event) {
        BlockState state;
        Block block;
        Map<Block, Block> map;
        ItemAbility action = event.getItemAbility();
        if (interactionMaps.containsKey(action) && (map = interactionMaps.get(action)).containsKey(block = (state = event.getState()).getBlock())) {
            Block finalBlock = map.get(block);
            event.setFinalState(ToolInteractionHandler.copyState(state, finalBlock));
        }
        for (BooleanPropertyWaxableBlock waxableBlock : booleanPropertySet) {
            BlockState state2;
            Block block2;
            if (waxableBlock.itemAbility != action || waxableBlock.block != (block2 = (state2 = event.getState()).getBlock()) || !((Boolean)state2.getValue((Property)waxableBlock.property)).booleanValue()) continue;
            event.setFinalState((BlockState)ToolInteractionHandler.copyState(state2, waxableBlock.block).setValue((Property)waxableBlock.property, (Comparable)Boolean.valueOf(false)));
        }
    }

    @PlayEvent
    public static void itemUse(ZRightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem() == Items.HONEYCOMB) {
            BlockPos pos = event.getPos();
            Level world = event.getLevel();
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (cleanToWaxMap.containsKey(block)) {
                Block alternate = cleanToWaxMap.get(block);
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)livingEntity;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(sp, pos, stack);
                }
                if (!world.isClientSide) {
                    world.setBlockAndUpdate(pos, ToolInteractionHandler.copyState(state, alternate));
                }
                world.levelEvent(event.getPlayer(), 3003, pos, 0);
                if (!event.getPlayer().getAbilities().instabuild) {
                    stack.setCount(stack.getCount() - 1);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            for (BooleanPropertyWaxableBlock waxableBlock : booleanPropertySet) {
                if (waxableBlock.block != block || ((Boolean)state.getValue((Property)waxableBlock.property)).booleanValue()) continue;
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)livingEntity;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(sp, pos, stack);
                }
                if (!world.isClientSide) {
                    world.setBlockAndUpdate(pos, (BlockState)ToolInteractionHandler.copyState(state, waxableBlock.block).setValue((Property)waxableBlock.property, (Comparable)Boolean.valueOf(true)));
                }
                world.levelEvent(event.getPlayer(), 3003, pos, 0);
                if (!event.getPlayer().getAbilities().instabuild) {
                    stack.setCount(stack.getCount() - 1);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private static BlockState copyState(BlockState original, Block newBlock) {
        BlockState retState = newBlock.defaultBlockState();
        for (Property prop : original.getProperties()) {
            if (!retState.hasProperty(prop)) continue;
            retState = (BlockState)retState.setValue(prop, original.getValue(prop));
        }
        return retState;
    }

    public static class BooleanPropertyWaxableBlock {
        public ZetaModule module;
        public Block block;
        public BooleanProperty property;
        public ItemAbility itemAbility;

        private BooleanPropertyWaxableBlock(ZetaModule module, Block block, BooleanProperty property, ItemAbility action) {
            this.module = module;
            this.block = block;
            this.property = property;
            this.itemAbility = action;
        }
    }
}

