/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.event.play;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.event.bus.IZetaPlayEvent;
import org.violetmoon.zeta.util.RegistryUtil;

public abstract class ZRecipeCrawl
implements IZetaPlayEvent {

    public static class Digest
    extends ZRecipeCrawl {
        private final Multimap<Item, ItemStack> digestion;
        private final Multimap<Item, ItemStack> backwardsDigestion;

        public Digest(Multimap<Item, ItemStack> digestion, Multimap<Item, ItemStack> backwardsDigestion) {
            this.digestion = digestion;
            this.backwardsDigestion = backwardsDigestion;
        }

        public boolean has(Item item, boolean backwards) {
            return (backwards ? this.backwardsDigestion : this.digestion).containsKey((Object)item);
        }

        public Collection<ItemStack> get(Item item, boolean backwards) {
            return (backwards ? this.backwardsDigestion : this.digestion).get((Object)item);
        }

        public void recursivelyFindCraftedItemsFromStrings(@Nullable Collection<String> derivationList, @Nullable Collection<String> whitelist, @Nullable Collection<String> blacklist, Consumer<Item> callback) {
            List<Item> parsedDerivationList = derivationList == null ? null : RegistryUtil.massRegistryGet(derivationList, BuiltInRegistries.ITEM);
            List<Item> parsedWhitelist = whitelist == null ? null : RegistryUtil.massRegistryGet(whitelist, BuiltInRegistries.ITEM);
            List<Item> parsedBlacklist = blacklist == null ? null : RegistryUtil.massRegistryGet(blacklist, BuiltInRegistries.ITEM);
            this.recursivelyFindCraftedItems(parsedDerivationList, parsedWhitelist, parsedBlacklist, callback);
        }

        public void recursivelyFindCraftedItems(@Nullable Collection<Item> derivationList, @Nullable Collection<Item> whitelist, @Nullable Collection<Item> blacklist, Consumer<Item> callback) {
            Collection<Object> trueDerivationList = derivationList == null ? Lists.newArrayList() : derivationList;
            Collection<Object> trueWhitelist = whitelist == null ? Lists.newArrayList() : whitelist;
            Collection<Object> trueBlacklist = blacklist == null ? Lists.newArrayList() : blacklist;
            Streams.concat((Stream[])new Stream[]{trueDerivationList.stream(), trueWhitelist.stream()}).forEach(callback);
            HashSet scanned = Sets.newHashSet(trueDerivationList);
            ArrayList toScan = Lists.newArrayList(trueDerivationList);
            while (!toScan.isEmpty()) {
                Item scan = (Item)toScan.remove(0);
                if (!this.digestion.containsKey((Object)scan)) continue;
                for (ItemStack digestedStack : this.digestion.get((Object)scan)) {
                    Item candidate = digestedStack.getItem();
                    if (scanned.contains(candidate)) continue;
                    scanned.add(candidate);
                    toScan.add(candidate);
                    if (trueBlacklist.contains(candidate)) continue;
                    callback.accept(candidate);
                }
            }
        }
    }

    public static abstract class Visit<T extends RecipeHolder<?>>
    extends ZRecipeCrawl {
        public final RecipeHolder<?> recipeHolder;
        public final Recipe<?> recipe;
        public final ResourceLocation recipeID;
        public final ItemStack output;
        public final NonNullList<Ingredient> ingredients;

        public Visit(RecipeHolder<?> recipeHolder, RegistryAccess access) {
            this.recipeHolder = recipeHolder;
            this.recipe = recipeHolder.value();
            this.recipeID = recipeHolder.id();
            this.output = recipeHolder.value().getResultItem((HolderLookup.Provider)access);
            this.ingredients = recipeHolder.value().getIngredients();
        }

        public static class Misc
        extends Visit<RecipeHolder<Recipe<?>>> {
            public Misc(RecipeHolder<Recipe<?>> recipeHolder, RegistryAccess access) {
                super(recipeHolder, access);
            }
        }

        public static class Cooking
        extends Visit<RecipeHolder<AbstractCookingRecipe>> {
            public Cooking(RecipeHolder<ShapelessRecipe> recipeHolder, RegistryAccess access) {
                super(recipeHolder, access);
            }
        }

        public static class Custom
        extends Visit<RecipeHolder<CustomRecipe>> {
            public Custom(RecipeHolder<CustomRecipe> recipeHolder, RegistryAccess access) {
                super(recipeHolder, access);
            }
        }

        public static class Shapeless
        extends Visit<RecipeHolder<ShapelessRecipe>> {
            public Shapeless(RecipeHolder<ShapelessRecipe> recipeHolder, RegistryAccess access) {
                super(recipeHolder, access);
            }
        }

        public static class Shaped
        extends Visit<RecipeHolder<ShapedRecipe>> {
            public Shaped(RecipeHolder<ShapedRecipe> recipeHolder, RegistryAccess access) {
                super(recipeHolder, access);
            }
        }
    }

    public static class Starting
    extends ZRecipeCrawl {
    }

    public static class Reset
    extends ZRecipeCrawl {
    }
}

