/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.client.config.screen;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.client.ZetaClient;
import org.violetmoon.zeta.client.config.screen.AbstractInputScreen;
import org.violetmoon.zeta.config.ChangeSet;
import org.violetmoon.zeta.config.ValueDefinition;

public abstract class AbstractEditBoxInputScreen<T>
extends AbstractInputScreen<T> {
    protected EditBox input;
    protected int VALID_COLOR = 0xE0E0E0;
    protected int INVALID_COLOR = 0xDD3322;

    public AbstractEditBoxInputScreen(ZetaClient zc, Screen parent, ChangeSet changes, ValueDefinition<T> valueDef) {
        super(zc, parent, changes, valueDef);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, (Component)Component.literal((String)this.def.getTranslatedDisplayName(x$0 -> I18n.get((String)x$0, (Object[])new Object[0]))).withStyle(ChatFormatting.BOLD), this.width / 2, 20, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, I18n.get((String)"zeta.gui.config.defaultvalue", (Object[])new Object[]{this.def.defaultValue}), this.width / 2, 30, 0xFFFFFF);
        this.input.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void init() {
        super.init();
        this.input = new EditBox(this.font, this.width / 2 - 100, 60, 200, 20, (Component)Component.literal((String)""));
        this.input.setMaxLength(this.maxStringLength());
        this.input.setResponder(this::onEdit);
        this.forceUpdateWidgetsTo(this.get());
        this.setInitialFocus((GuiEventListener)this.input);
        this.addWidget((GuiEventListener)this.input);
    }

    protected void onEdit(String newString) {
        T parsed = this.fromString(newString);
        if (parsed != null && this.def.validate(parsed) && newString.length() < this.maxStringLength()) {
            this.set(parsed);
            this.input.setTextColor(this.VALID_COLOR);
            this.updateButtonStatus(true);
        } else {
            this.input.setTextColor(this.INVALID_COLOR);
            this.updateButtonStatus(false);
        }
    }

    @Override
    protected void forceUpdateWidgetsTo(T value) {
        String asString = this.toString(value);
        T roundtrip = this.fromString(asString);
        if (roundtrip == null) {
            this.input.setValue(this.toString(this.def.defaultValue));
        } else {
            this.input.setValue(asString);
        }
        this.setInitialFocus((GuiEventListener)this.input);
    }

    protected String toString(T thing) {
        return thing.toString();
    }

    protected int maxStringLength() {
        return 256;
    }

    @Nullable
    protected abstract T fromString(String var1);
}

