/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.advancement.modifier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.BredAnimalsTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.violetmoon.zeta.advancement.AdvancementModifier;
import org.violetmoon.zeta.api.IMutableAdvancement;
import org.violetmoon.zeta.module.ZetaModule;

public class TwoByTwoModifier
extends AdvancementModifier {
    private static final ResourceLocation TARGET = ResourceLocation.withDefaultNamespace((String)"husbandry/bred_all_animals");
    final Set<EntityType<?>> entityTypes;

    public TwoByTwoModifier(ZetaModule module, Set<EntityType<?>> entityTypes) {
        super(module);
        this.entityTypes = entityTypes;
        Preconditions.checkArgument((!entityTypes.isEmpty() ? 1 : 0) != 0, (Object)"Advancement modifier list cant be empty");
    }

    @Override
    public Set<ResourceLocation> getTargets() {
        return ImmutableSet.of((Object)TARGET);
    }

    @Override
    public boolean apply(ResourceLocation res, IMutableAdvancement adv, RegistryAccess registry) {
        for (EntityType<?> type : this.entityTypes) {
            Criterion criterion = BredAnimalsTrigger.TriggerInstance.bredAnimals((EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of(type)));
            String name = BuiltInRegistries.ENTITY_TYPE.getKey(type).toString();
            adv.addRequiredCriterion(name, criterion);
        }
        return true;
    }
}

