/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.config;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.config.Definition;

public class ValueDefinition<T>
extends Definition {
    @NotNull
    public final T defaultValue;
    @Nullable
    public final Predicate<Object> validator;

    public ValueDefinition(Builder<T> builder) {
        super(builder);
        this.defaultValue = Preconditions.checkNotNull(builder.defaultValue, (Object)"ValueDefinition needs a default value");
        this.validator = builder.validator;
    }

    public boolean isOfType(Class<?> clazz) {
        return clazz.isAssignableFrom(this.defaultValue.getClass());
    }

    @Nullable
    public <X> ValueDefinition<X> downcast(Class<X> newType) {
        if (this.isOfType(newType)) {
            return this;
        }
        return null;
    }

    public boolean validate(Object underTest) {
        if (underTest == null) {
            return false;
        }
        boolean isList = List.class.isAssignableFrom(this.defaultValue.getClass());
        boolean isSubtype = this.defaultValue.getClass().isAssignableFrom(underTest.getClass());
        if (!isList && !isSubtype) {
            return false;
        }
        if (this.validator == null) {
            return true;
        }
        return this.validator.test(underTest);
    }

    public String toString() {
        return "ValueDefinition{" + this.name + "}";
    }

    public static class Builder<T>
    extends Definition.Builder<Builder<T>, ValueDefinition<T>> {
        @Nullable
        protected T defaultValue;
        @Nullable
        protected Predicate<Object> validator;

        @Override
        public ValueDefinition<T> build() {
            return new ValueDefinition(this);
        }

        public Builder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> validator(Predicate<Object> validator) {
            this.validator = validator;
            return this;
        }
    }
}

