/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import org.violetmoon.quark.content.world.module.MonsterBoxModule;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.util.BlockUtils;
import org.violetmoon.zeta.world.generator.Generator;

public class MonsterBoxGenerator
extends Generator {
    public MonsterBoxGenerator(DimensionConfig dimConfig) {
        super(dimConfig);
    }

    public void generateChunk(WorldGenRegion world, ChunkGenerator generator, RandomSource rand, BlockPos chunkCorner) {
        if (generator instanceof FlatLevelSource) {
            return;
        }
        block0: for (double chance = MonsterBoxModule.chancePerChunk; chance > 0.0 && rand.nextDouble() <= chance; chance -= 1.0) {
            BlockPos.MutableBlockPos pos = chunkCorner.offset(rand.nextInt(16), rand.nextInt(MonsterBoxModule.minY, MonsterBoxModule.maxY), rand.nextInt(16)).mutable();
            for (int moves = 0; moves < MonsterBoxModule.searchRange && pos.getY() > MonsterBoxModule.minY; ++moves) {
                BlockState state = world.getBlockState((BlockPos)pos);
                if (this.canPlaceHere(world, pos, state)) {
                    world.setBlock((BlockPos)pos, MonsterBoxModule.monster_box.defaultBlockState(), 0);
                    continue block0;
                }
                pos = pos.move(0, -1, 0);
            }
        }
    }

    private boolean canPlaceHere(WorldGenRegion level, BlockPos.MutableBlockPos pos, BlockState state) {
        if (!state.canBeReplaced() || state.liquid()) {
            return false;
        }
        BlockPos.MutableBlockPos below = pos.move(0, -1, 0);
        BlockState belowState = level.getBlockState((BlockPos)below);
        boolean result = BlockUtils.isStoneBased((BlockState)belowState, (BlockGetter)level, (BlockPos)below) && belowState.isFaceSturdy((BlockGetter)level, (BlockPos)below, Direction.UP);
        pos.move(0, 1, 0);
        return result;
    }
}

