/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.base.network.message.UpdateTridentMessage;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.client.render.GlintRenderTypes;
import org.violetmoon.quark.content.tools.item.RuneItem;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.quark.content.tools.recipe.SmithingRuneRecipe;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorAbstractArrow;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorArmorTrim;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.event.play.loading.ZLootTableLoad;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class ColorRunesModule
extends ZetaModule {
    private static final ThreadLocal<RuneColor> targetColor = new ThreadLocal();
    @Hint
    public static Item rune;
    @Config
    public static int dungeonWeight;
    @Config
    public static int netherFortressWeight;
    @Config
    public static int jungleTempleWeight;
    @Config
    public static int desertTempleWeight;
    @Config
    public static int itemQuality;
    public static ManualTrigger fullRainbowTrigger;
    private static final Map<ThrownTrident, ItemStack> TRIDENT_STACK_REFERENCES;

    public static void setTargetStack(ItemStack stack) {
        ColorRunesModule.setTargetColor(ColorRunesModule.getStackColor(stack));
    }

    public static void setTargetColor(RuneColor color) {
        targetColor.set(color);
    }

    public static RuneColor changeColor() {
        return targetColor.get();
    }

    @Nullable
    public static RuneColor getStackColor(ItemStack target) {
        if (target == null) {
            return null;
        }
        RuneColor manualColor = ColorRunesModule.getAppliedStackColor(target);
        if (manualColor != null) {
            return manualColor;
        }
        return RuneColor.byName((String)target.get(QuarkDataComponents.RUNE_COLOR));
    }

    @Nullable
    public static RuneColor getAppliedStackColor(ItemStack target) {
        if (target == null) {
            return null;
        }
        if (target.getItem() == Items.ENCHANTED_BOOK) {
            return AncientTomesModule.shiftRuneColor(target);
        }
        return RuneColor.byName((String)target.get(QuarkDataComponents.RUNE_COLOR));
    }

    public static void syncTrident(Consumer<CustomPacketPayload> packetConsumer, ThrownTrident trident, boolean force) {
        ItemStack stack = ((AccessorAbstractArrow)trident).quark$getPickupItem();
        ItemStack prev = TRIDENT_STACK_REFERENCES.get(trident);
        if (force || prev == null || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)prev)) {
            packetConsumer.accept(new UpdateTridentMessage(trident.getId(), stack));
        } else {
            TRIDENT_STACK_REFERENCES.put(trident, stack);
        }
    }

    public static ItemStack withRune(ItemStack stack, @Nullable RuneColor color) {
        if (color != null) {
            stack.set(QuarkDataComponents.RUNE_COLOR, (Object)color.getSerializedName());
        }
        return stack;
    }

    @LoadEvent
    public final void register(ZRegister event) {
        event.getRegistry().register((Object)SmithingRuneRecipe.SERIALIZER, "smithing_rune", Registries.RECIPE_SERIALIZER);
        rune = new RuneItem("smithing_template_rune", this);
        fullRainbowTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("full_rainbow");
    }

    @PlayEvent
    public void onLootTableLoad(ZLootTableLoad event) {
        int weight = 0;
        if (event.getName().equals((Object)BuiltInLootTables.SIMPLE_DUNGEON)) {
            weight = dungeonWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.NETHER_BRIDGE)) {
            weight = netherFortressWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.JUNGLE_TEMPLE)) {
            weight = jungleTempleWeight;
        } else if (event.getName().equals((Object)BuiltInLootTables.DESERT_PYRAMID)) {
            weight = desertTempleWeight;
        }
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.lootTableItem((ItemLike)rune).setWeight(weight).setQuality(itemQuality).build();
            event.add(entry);
        }
    }

    @PlayEvent
    public void onPlayerTick(ZPlayerTick.Start event) {
        boolean rainbow;
        String tag = "quark:what_are_you_gay_or_something";
        Player player = event.getPlayer();
        boolean wasRainbow = player.getPersistentData().getBoolean("quark:what_are_you_gay_or_something");
        if (wasRainbow != (rainbow = this.isPlayerRainbow(player))) {
            player.getPersistentData().putBoolean("quark:what_are_you_gay_or_something", rainbow);
            if (rainbow && player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                fullRainbowTrigger.trigger(sp);
            }
        }
    }

    private boolean isPlayerRainbow(Player player) {
        ImmutableSet checks = ImmutableSet.of((Object)EquipmentSlot.HEAD, (Object)EquipmentSlot.CHEST, (Object)EquipmentSlot.LEGS, (Object)EquipmentSlot.FEET);
        for (EquipmentSlot slot : checks) {
            ItemStack stack = player.getItemBySlot(slot);
            if (!stack.isEmpty() && ColorRunesModule.getStackColor(stack) == RuneColor.RAINBOW) continue;
            return false;
        }
        return true;
    }

    public static boolean canHaveRune(ItemStack stack) {
        return stack.isEnchanted() || stack.getItem() == Items.COMPASS && stack.has(DataComponents.LODESTONE_TRACKER);
    }

    public static Component extremeRainbow(Component component) {
        String emphasis = component.getString();
        float time = Quark.proxy.getVisualTime();
        MutableComponent emphasized = Component.empty();
        for (int i = 0; i < emphasis.length(); ++i) {
            emphasized.append((Component)ColorRunesModule.rainbow(Component.literal((String)("" + emphasis.charAt(i))), i, time));
        }
        return emphasized;
    }

    private static MutableComponent rainbow(MutableComponent component, int shift, float time) {
        return component.withStyle(s -> s.withColor(TextColor.fromRgb((int)Mth.hsvToRgb((float)((time + (float)shift) * 2.0f % 360.0f / 360.0f), (float)1.0f, (float)1.0f))));
    }

    public static void appendRuneTooltip(ItemStack stack, List<Component> components) {
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        RuneColor color = ColorRunesModule.getAppliedStackColor(stack);
        if (trim != null && !((AccessorArmorTrim)trim).showInTooltip()) {
            return;
        }
        if (color != null && stack.getItem() != Items.ENCHANTED_BOOK) {
            if (!components.contains(AccessorArmorTrim.getUPGRADE_TITLE())) {
                components.add(AccessorArmorTrim.getUPGRADE_TITLE());
            }
            MutableComponent baseComponent = Component.translatable((String)("rune.quark." + color.getName()));
            if (color == RuneColor.RAINBOW) {
                components.add((Component)CommonComponents.space().append(ColorRunesModule.extremeRainbow((Component)baseComponent)));
            } else {
                components.add((Component)CommonComponents.space().append((Component)baseComponent.withStyle(style -> style.withColor(color.getTextColor()))));
            }
        }
    }

    static {
        dungeonWeight = 10;
        netherFortressWeight = 8;
        jungleTempleWeight = 8;
        desertTempleWeight = 8;
        itemQuality = 0;
        TRIDENT_STACK_REFERENCES = new WeakHashMap<ThrownTrident, ItemStack>();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ColorRunesModule {
        public static RenderType getGlint() {
            return Client.renderType(GlintRenderTypes.glint, RenderType::glint);
        }

        public static RenderType getGlintTranslucent() {
            return Client.renderType(GlintRenderTypes.glintTranslucent, RenderType::glintTranslucent);
        }

        public static RenderType getEntityGlint() {
            return Client.renderType(GlintRenderTypes.entityGlint, RenderType::entityGlint);
        }

        public static RenderType getGlintDirect() {
            return Client.renderType(GlintRenderTypes.glintDirect, RenderType::entityGlintDirect);
        }

        public static RenderType getEntityGlintDirect() {
            return Client.renderType(GlintRenderTypes.entityGlintDirect, RenderType::entityGlintDirect);
        }

        public static RenderType getArmorGlint() {
            return Client.renderType(GlintRenderTypes.armorGlint, RenderType::armorEntityGlint);
        }

        public static RenderType getArmorEntityGlint() {
            return Client.renderType(GlintRenderTypes.armorEntityGlint, RenderType::armorEntityGlint);
        }

        private static RenderType renderType(Map<RuneColor, RenderType> map, Supplier<RenderType> vanilla) {
            RuneColor color = Client.changeColor();
            return color != null ? map.get(color) : vanilla.get();
        }
    }
}

