/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.module.BottledCloudModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class BottledCloudItem
extends ZetaItem {
    public BottledCloudItem(ZetaModule module) {
        super("bottled_cloud", module, new Item.Properties());
        CreativeTabManager.addNextToItem((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this, (ItemLike)Items.MILK_BUCKET, (boolean)false);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        HitResult result = Quark.ZETA.raytracingUtil.rayTrace((Entity)player, world, player, ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY);
        if (result instanceof BlockHitResult) {
            BlockHitResult bresult = (BlockHitResult)result;
            BlockPos pos = bresult.getBlockPos();
            if (!world.isEmptyBlock(pos)) {
                pos = pos.relative(bresult.getDirection());
            }
            if (world.isEmptyBlock(pos) && world.isInWorldBounds(pos) && Quark.FLAN_INTEGRATION.canPlace(player, pos)) {
                if (!world.isClientSide) {
                    world.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
                    world.setBlockAndUpdate(pos, BottledCloudModule.cloud.defaultBlockState());
                }
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                    ItemStack returnStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                    if (stack.isEmpty()) {
                        stack = returnStack;
                    } else if (!player.addItem(returnStack)) {
                        player.drop(returnStack, false);
                    }
                }
                player.getCooldowns().addCooldown((Item)this, 10);
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }
}

