/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class AncientTomeItem
extends ZetaItem
implements CreativeTabManager.AppendsUniquely {
    public AncientTomeItem(ZetaModule module) {
        super("ancient_tome", module, new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
        CreativeTabManager.addToTab((ResourceKey)CreativeModeTabs.INGREDIENTS, (ItemLike)this);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }

    public static ItemStack getEnchantedItemStack(Holder<Enchantment> enchantment) {
        ItemStack stack = new ItemStack((ItemLike)AncientTomesModule.ancient_tome);
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        enchantments.set(enchantment, ((Enchantment)enchantment.value()).getMaxLevel());
        stack.set(QuarkDataComponents.TOME_ENCHANTMENTS, (Object)enchantments.toImmutable());
        return stack;
    }

    public static Component getFullTooltipText(Holder<Enchantment> ench) {
        return Component.translatable((String)"quark.misc.ancient_tome_tooltip", (Object[])new Object[]{Component.translatable((String)((Enchantment)ench.value()).description().getString()), Component.translatable((String)("enchantment.level." + (((Enchantment)ench.value()).getMaxLevel() + AncientTomesModule.maxLimitBreakLevels)))}).withStyle(ChatFormatting.GRAY);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, tooltipContext, tooltips, flag);
        Holder<Enchantment> ench = AncientTomesModule.getTomeEnchantment(stack);
        Component component = ench != null ? AncientTomeItem.getFullTooltipText(ench) : Component.translatable((String)"quark.misc.ancient_tome_tooltip_any").withStyle(ChatFormatting.GRAY);
        tooltips.add(component);
        if (AncientTomesModule.curseGear) {
            tooltips.add((Component)Component.translatable((String)"quark.misc.ancient_tome_tooltip_curse").withStyle(ChatFormatting.RED));
        }
    }

    public List<ItemStack> appendItemsToCreativeTab(RegistryAccess access) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ((Registry)access.registry(Registries.ENCHANTMENT).get()).asHolderIdMap().forEach(ench -> {
            if (!(AncientTomesModule.sanityCheck && ((Enchantment)ench.value()).getMaxLevel() == 1 || AncientTomesModule.isInitialized() || !AncientTomesModule.validEnchants.contains(ench))) {
                items.add(AncientTomeItem.getEnchantedItemStack((Holder<Enchantment>)ench));
            }
        });
        return items;
    }
}

