/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.violetmoon.quark.base.network.QuarkNetwork;
import org.violetmoon.quark.catnip.net.base.BasePacketPayload;
import org.violetmoon.quark.catnip.net.base.ClientboundPacketPayload;

public record UpdateTridentMessage(int tridentID, ItemStack stack) implements ClientboundPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateTridentMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, UpdateTridentMessage::tridentID, (StreamCodec)ItemStack.STREAM_CODEC, UpdateTridentMessage::stack, UpdateTridentMessage::new);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(LocalPlayer player) {
        Entity entity;
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && (entity = level.getEntity(this.tridentID)) instanceof ThrownTrident) {
            ThrownTrident trident = (ThrownTrident)entity;
            trident.pickupItemStack = this.stack;
        }
    }

    @Override
    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return QuarkNetwork.UPDATE_TRIDENT_MESSAGE;
    }
}

