/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.StoolBlock;
import org.violetmoon.quark.content.building.client.render.entity.StoolEntityRenderer;
import org.violetmoon.quark.content.building.entity.Stool;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="building")
public class StoolsModule
extends ZetaModule {
    public static List<StoolBlock> stools = new ArrayList<StoolBlock>();
    public static EntityType<Stool> stoolEntity;
    @Hint
    TagKey<Item> stoolsTag;

    @LoadEvent
    public final void register(ZRegister event) {
        CreativeTabManager.startChain((ResourceKey)CreativeModeTabs.COLORED_BLOCKS, (boolean)false, (boolean)false, (ItemLike)Blocks.PINK_BED);
        for (DyeColor dye : MiscUtil.CREATIVE_COLOR_ORDER) {
            stools.add(new StoolBlock(this, dye));
        }
        CreativeTabManager.endChain();
        CreativeTabManager.startChain((ResourceKey)CreativeModeTabs.FUNCTIONAL_BLOCKS, (boolean)false, (boolean)false, (ItemLike)Blocks.PINK_BED);
        for (StoolBlock s : stools) {
            s.setCreativeTab(CreativeModeTabs.FUNCTIONAL_BLOCKS, (ItemLike)Blocks.PINK_BED, false);
        }
        CreativeTabManager.endChain();
        stoolEntity = EntityType.Builder.of(Stool::new, (MobCategory)MobCategory.MISC).sized(0.375f, 0.5f).clientTrackingRange(3).updateInterval(5).setShouldReceiveVelocityUpdates(false).build("stool");
        Quark.ZETA.registry.register(stoolEntity, "stool", Registries.ENTITY_TYPE);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        this.stoolsTag = Quark.asTagKey(Registries.ITEM, "stools");
    }

    @PlayEvent
    public void itemUsed(ZRightClickBlock event) {
        BlockState state;
        Block block;
        if (event.getEntity().isShiftKeyDown() && event.getItemStack().getItem() instanceof BlockItem && event.getFace() == Direction.UP && (block = (state = event.getLevel().getBlockState(event.getPos())).getBlock()) instanceof StoolBlock) {
            StoolBlock stool = (StoolBlock)block;
            stool.blockClicked(event.getLevel(), event.getPos());
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends StoolsModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            EntityRenderers.register((EntityType)stoolEntity, StoolEntityRenderer::new);
        }
    }
}

