/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.ICrawlSpaceBlock;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;

public abstract class HollowFrameBlock
extends ZetaBlock
implements SimpleWaterloggedBlock,
ICrawlSpaceBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHELL = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape SHAPE_BOTTOM = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private static final VoxelShape SHAPE_TOP = Block.box((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final byte FLAG_BOTTOM = 1;
    private static final byte FLAG_TOP = 2;
    private static final byte FLAG_NORTH = 4;
    private static final byte FLAG_SOUTH = 8;
    private static final byte FLAG_WEST = 16;
    private static final byte FLAG_EAST = 32;
    private static final VoxelShape[] SHAPES = new VoxelShape[64];

    public HollowFrameBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean bottom(byte shapeCode) {
        return (shapeCode & 1) != 0;
    }

    public static boolean top(byte shapeCode) {
        return (shapeCode & 2) != 0;
    }

    public static boolean north(byte shapeCode) {
        return (shapeCode & 4) != 0;
    }

    public static boolean south(byte shapeCode) {
        return (shapeCode & 8) != 0;
    }

    public static boolean west(byte shapeCode) {
        return (shapeCode & 0x10) != 0;
    }

    public static boolean east(byte shapeCode) {
        return (shapeCode & 0x20) != 0;
    }

    public static boolean hasDirection(byte shapeCode, Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> HollowFrameBlock.bottom(shapeCode);
            case Direction.UP -> HollowFrameBlock.top(shapeCode);
            case Direction.NORTH -> HollowFrameBlock.north(shapeCode);
            case Direction.SOUTH -> HollowFrameBlock.south(shapeCode);
            case Direction.WEST -> HollowFrameBlock.west(shapeCode);
            case Direction.EAST -> HollowFrameBlock.east(shapeCode);
        };
    }

    public boolean hasDirection(BlockState state, Direction direction) {
        return HollowFrameBlock.hasDirection(this.getShapeCode(state), direction);
    }

    protected static byte shapeCode(boolean bottom, boolean top, boolean north, boolean south, boolean west, boolean east) {
        byte flag = 0;
        if (bottom) {
            flag = (byte)(flag | 1);
        }
        if (top) {
            flag = (byte)(flag | 2);
        }
        if (north) {
            flag = (byte)(flag | 4);
        }
        if (south) {
            flag = (byte)(flag | 8);
        }
        if (west) {
            flag = (byte)(flag | 0x10);
        }
        if (east) {
            flag = (byte)(flag | 0x20);
        }
        return flag;
    }

    protected static byte shapeCode(BlockState state, BooleanProperty bottom, BooleanProperty top, BooleanProperty north, BooleanProperty south, BooleanProperty west, BooleanProperty east) {
        return HollowFrameBlock.shapeCode((Boolean)state.getValue((Property)bottom), (Boolean)state.getValue((Property)top), (Boolean)state.getValue((Property)north), (Boolean)state.getValue((Property)south), (Boolean)state.getValue((Property)west), (Boolean)state.getValue((Property)east));
    }

    public abstract byte getShapeCode(BlockState var1);

    @Override
    public boolean canCrawl(Level level, BlockState state, BlockPos pos, Direction direction) {
        return this.hasDirection(state, direction.getOpposite());
    }

    public boolean hasDynamicShape() {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPES[this.getShapeCode(state)];
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        byte code = this.getShapeCode(state);
        if (ctx.isDescending()) {
            LivingEntity living;
            EntityCollisionContext eCtx;
            Entity entity;
            code = (byte)(code & 0xFFFFFFFD);
            if (ctx instanceof EntityCollisionContext && (entity = (eCtx = (EntityCollisionContext)ctx).getEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).getY() >= (double)pos.getY() + SHAPE_BOTTOM.max(Direction.Axis.Y)) {
                code = (byte)(code & 0xFFFFFFFE);
            }
        }
        return SHAPES[code];
    }

    public boolean isLadderZeta(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        if (entity.isVisuallyCrawling() && entity.isShiftKeyDown()) {
            return false;
        }
        byte shapeCode = this.getShapeCode(state);
        if (!HollowFrameBlock.bottom(shapeCode) && !HollowFrameBlock.top(shapeCode)) {
            return false;
        }
        Vec3 eyePos = entity.getEyePosition();
        double pad = 0.125;
        if (eyePos.x > (double)pos.getX() + pad && eyePos.z > (double)pos.getZ() + pad && eyePos.x < (double)(pos.getX() + 1) - pad && eyePos.z < (double)(pos.getZ() + 1) - pad) {
            return true;
        }
        return super.isLadderZeta(state, level, pos, entity);
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        byte shapeCode = this.getShapeCode(state);
        return (Boolean)state.getValue((Property)WATERLOGGED) == false && HollowFrameBlock.bottom(shapeCode) && HollowFrameBlock.top(shapeCode);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState p_56967_) {
        return true;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> def) {
        super.createBlockStateDefinition(def);
        def.add(new Property[]{WATERLOGGED});
    }

    static {
        for (byte shapeCode = 0; shapeCode < 64; shapeCode = (byte)(shapeCode + 1)) {
            VoxelShape shape = SHELL;
            if (HollowFrameBlock.bottom(shapeCode)) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_BOTTOM, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            if (HollowFrameBlock.top(shapeCode)) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_TOP, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            if (HollowFrameBlock.north(shapeCode)) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_NORTH, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            if (HollowFrameBlock.south(shapeCode)) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            if (HollowFrameBlock.west(shapeCode)) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_WEST, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            if (HollowFrameBlock.east(shapeCode)) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)SHAPE_EAST, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            HollowFrameBlock.SHAPES[shapeCode] = shape;
        }
    }
}

