/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.ZEntityJoinLevel;
import org.violetmoon.zeta.event.play.entity.living.ZBabyEntitySpawn;
import org.violetmoon.zeta.event.play.entity.living.ZLivingTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tweaks")
public class PigLittersModule
extends ZetaModule {
    private static final String GOLDEN_CARROT_TAG = "quark:AteGoldenCarrot";
    @Config
    @Config.Min(value=1.0)
    public static int minPigLitterSize = 2;
    @Config
    @Config.Min(value=1.0)
    public static int maxPigLitterSize = 3;
    @Config
    public static boolean pigsEatGoldenCarrots = true;
    @Config
    @Config.Min(value=0.0)
    public static int minGoldenCarrotBoost = 0;
    @Config
    @Config.Min(value=0.0)
    public static int maxGoldenCarrotBoost = 2;

    public static boolean canEat(ItemStack stack) {
        return Quark.ZETA.modules.isEnabled(PigLittersModule.class) && pigsEatGoldenCarrots && stack.is(Items.GOLDEN_CARROT);
    }

    public static void onEat(Animal animal, ItemStack stack) {
        if (animal instanceof Pig && PigLittersModule.canEat(stack)) {
            animal.getPersistentData().putBoolean(GOLDEN_CARROT_TAG, true);
        }
    }

    private static int getNumberBetween(RandomSource random, int boundA, int boundB) {
        int min = Math.min(boundA, boundB);
        int max = Math.max(boundA, boundB);
        return min + random.nextInt(max - min + 1);
    }

    @PlayEvent
    public void onPigAppear(ZEntityJoinLevel event) {
        Entity entity;
        if (pigsEatGoldenCarrots && (entity = event.getEntity()) instanceof Pig) {
            int priority;
            Pig pig = (Pig)entity;
            boolean alreadySetUp = pig.goalSelector.getAvailableGoals().stream().anyMatch(goal -> {
                Goal patt0$temp = goal.getGoal();
                if (!(patt0$temp instanceof TemptGoal)) return false;
                TemptGoal tempt = (TemptGoal)patt0$temp;
                if (!tempt.items.test(new ItemStack((ItemLike)Items.GOLDEN_CARROT))) return false;
                return true;
            });
            if (!alreadySetUp && (priority = pig.goalSelector.getAvailableGoals().stream().filter(goal -> goal.getGoal() instanceof TemptGoal).findFirst().map(WrappedGoal::getPriority).orElse(-1).intValue()) >= 0) {
                MiscUtil.addGoalJustAfterLatestWithPriority((GoalSelector)pig.goalSelector, (int)4, (Goal)new TemptGoal((PathfinderMob)pig, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_CARROT}), false));
            }
        }
    }

    @PlayEvent
    public void onEntityUpdate(ZLivingTick event) {
        Animal animal;
        Entity entity = event.getEntity();
        if (entity instanceof Animal && !(animal = (Animal)entity).isInLove()) {
            animal.getPersistentData().remove(GOLDEN_CARROT_TAG);
        }
    }

    @PlayEvent
    public void onPigBreed(ZBabyEntitySpawn.Lowest event) {
        Level lvl;
        AgeableMob mob = event.getChild();
        Mob mobA = event.getParentA();
        Mob mobB = event.getParentB();
        if (mob instanceof Pig && (lvl = mob.level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)lvl;
            if (mobA instanceof Animal) {
                Animal parentA = (Animal)mobA;
                if (mobB instanceof Animal) {
                    Animal parentB = (Animal)mobB;
                    int litterSize = PigLittersModule.getNumberBetween(level.random, minPigLitterSize, maxPigLitterSize);
                    if (mobA.getPersistentData().getBoolean(GOLDEN_CARROT_TAG)) {
                        litterSize += PigLittersModule.getNumberBetween(level.random, minGoldenCarrotBoost, maxGoldenCarrotBoost);
                    }
                    if (mobB.getPersistentData().getBoolean(GOLDEN_CARROT_TAG)) {
                        litterSize += PigLittersModule.getNumberBetween(level.random, minGoldenCarrotBoost, maxGoldenCarrotBoost);
                    }
                    if (litterSize > 1) {
                        for (int i = 1; i < litterSize; ++i) {
                            AgeableMob newChild = parentA.getBreedOffspring(level, (AgeableMob)parentB);
                            if (newChild == null) continue;
                            Player cause = event.getCausedByPlayer();
                            if (cause instanceof ServerPlayer) {
                                ServerPlayer player = (ServerPlayer)cause;
                                player.awardStat(Stats.ANIMALS_BRED);
                                CriteriaTriggers.BRED_ANIMALS.trigger(player, parentA, parentB, newChild);
                            }
                            newChild.setBaby(true);
                            newChild.moveTo(parentA.getX(), parentA.getY(), parentA.getZ(), 0.0f, 0.0f);
                            level.addFreshEntityWithPassengers((Entity)newChild);
                        }
                    }
                }
            }
        }
    }
}

