/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import net.minecraft.world.level.levelgen.GenerationStep;
import org.violetmoon.quark.content.world.gen.CherryGroveWaterPetalsGenerator;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world", antiOverlap={"pinkpetalcarpet", "hanaikada"})
public class CherryGroveWaterPetalsModule
extends ZetaModule {
    public static boolean staticEnabled;
    @Config(description="The chance for a Cherry Grove chunk to attempt to spawn petals on top of water (1 is 100%, 0 is 0%)")
    public static double chancePerChunk;
    @Config(description="Should a chunk have water petals, how many would the generator try to place")
    public static int triesPerChunk;
    @Config(description="The 'size' of groups of petals")
    public static int size;
    @Config(description="Groups of petals will be +/- this size, set to 0 to disable variation")
    public static int sizeVariation;
    @Config(description="If true, Cherry Leaf Carpet from Leaf Carpet Module (from Building category) will be used instead of Pink Petals, assuming it is enabled; if false, requires Petals On Water Module (from Tweaks category) to be enabled")
    public static boolean useCarpet;
    @Config
    public static CompoundBiomeConfig biomes;
    @Config
    public static DimensionConfig dimensions;

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new CherryGroveWaterPetalsGenerator(dimensions), (GenerationStep.Decoration)GenerationStep.Decoration.TOP_LAYER_MODIFICATION, (int)1);
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
    }

    static {
        chancePerChunk = 0.25;
        triesPerChunk = 1;
        size = 2;
        sizeVariation = 1;
        useCarpet = false;
        biomes = CompoundBiomeConfig.fromBiomeReslocs((boolean)false, (String[])new String[]{"minecraft:cherry_grove"});
        dimensions = DimensionConfig.overworld((boolean)false);
    }
}

