/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FavorBlockGoal
extends Goal {
    private final PathfinderMob creature;
    private final double movementSpeed;
    private final Predicate<BlockState> targetBlock;
    protected int runDelay;
    private int timeoutCounter;
    private int maxStayTicks;
    protected BlockPos destinationBlock = BlockPos.ZERO;

    public FavorBlockGoal(PathfinderMob creature, double speed, Predicate<BlockState> predicate) {
        this.creature = creature;
        this.movementSpeed = speed;
        this.targetBlock = predicate;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public FavorBlockGoal(PathfinderMob creature, double speed, TagKey<Block> tag) {
        this(creature, speed, (BlockState state) -> state.is(tag));
    }

    public FavorBlockGoal(PathfinderMob creature, double speed, Block block) {
        this(creature, speed, (BlockState state) -> state.getBlock() == block);
    }

    public boolean canUse() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = 200 + this.creature.getRandom().nextInt(200);
        return this.searchForDestination();
    }

    public boolean canContinueToUse() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.targetBlock.test(this.creature.level().getBlockState(this.destinationBlock));
    }

    public void start() {
        this.creature.getNavigation().moveTo((double)this.destinationBlock.getX() + 0.5, (double)(this.destinationBlock.getY() + 1), (double)this.destinationBlock.getZ() + 0.5, this.movementSpeed);
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.getRandom().nextInt(this.creature.getRandom().nextInt(1200) + 1200) + 1200;
    }

    public void tick() {
        Vec3 vec3 = new Vec3((double)this.destinationBlock.getX(), (double)this.destinationBlock.getY(), (double)this.destinationBlock.getZ());
        if (this.creature.distanceToSqr(vec3.add(0.5, 1.5, 0.5)) > 1.0) {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.creature.getNavigation().moveTo((double)this.destinationBlock.getX() + 0.5, (double)(this.destinationBlock.getY() + 1), (double)this.destinationBlock.getZ() + 0.5, this.movementSpeed);
            }
        } else {
            --this.timeoutCounter;
        }
    }

    private boolean searchForDestination() {
        double followRange = this.creature.getAttribute(Attributes.FOLLOW_RANGE).getValue();
        Vec3 cpos = this.creature.position();
        double xBase = cpos.x;
        double yBase = cpos.y;
        double zBase = cpos.z;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int yShift = 0;
        while (yShift <= 1) {
            int seekDist = 0;
            while ((double)seekDist < followRange) {
                int xShift = 0;
                while (xShift <= seekDist) {
                    int zShift;
                    int n = zShift = xShift < seekDist && xShift > -seekDist ? seekDist : 0;
                    while (zShift <= seekDist) {
                        pos.set(xBase + (double)xShift, yBase + (double)yShift - 1.0, zBase + (double)zShift);
                        if (this.creature.isWithinRestriction((BlockPos)pos) && this.targetBlock.test(this.creature.level().getBlockState((BlockPos)pos))) {
                            this.destinationBlock = pos;
                            return true;
                        }
                        zShift = zShift > 0 ? -zShift : 1 - zShift;
                    }
                    xShift = xShift > 0 ? -xShift : 1 - xShift;
                }
                ++seekDist;
            }
            yShift = yShift > 0 ? -yShift : 1 - yShift;
        }
        return false;
    }
}

