/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.entity.Gravisand;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BlockUtils;

public class GravisandBlock
extends ZetaBlock {
    public GravisandBlock(String regname, @Nullable ZetaModule module, BlockBehaviour.Properties properties) {
        super(regname, module, properties);
        if (module == null) {
            return;
        }
        this.setCreativeTab(CreativeModeTabs.REDSTONE_BLOCKS);
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        this.checkRedstone(world, pos);
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        this.checkRedstone(worldIn, pos);
    }

    private void checkRedstone(Level worldIn, BlockPos pos) {
        boolean powered = worldIn.hasNeighborSignal(pos);
        if (powered) {
            worldIn.scheduleTick(pos, (Block)this, 2);
        }
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, @NotNull Level worldIn, @NotNull BlockPos pos) {
        return 15;
    }

    public void tick(@NotNull BlockState state, ServerLevel worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (!worldIn.isClientSide && this.checkFallable(state, (Level)worldIn, pos)) {
            for (Direction face : Direction.values()) {
                BlockPos offPos = pos.relative(face);
                BlockState offState = worldIn.getBlockState(offPos);
                if (offState.getBlock() != this) continue;
                worldIn.scheduleTick(offPos, (Block)this, 2);
            }
        }
    }

    private boolean checkFallable(BlockState state, Level worldIn, BlockPos pos) {
        if (!worldIn.isClientSide) {
            if (this.tryFall(state, worldIn, pos, Direction.DOWN)) {
                return true;
            }
            return this.tryFall(state, worldIn, pos, Direction.UP);
        }
        return false;
    }

    private boolean tryFall(BlockState state, Level worldIn, BlockPos pos, Direction facing) {
        BlockPos target = pos.relative(facing);
        if ((worldIn.isEmptyBlock(target) || BlockUtils.canFallThrough((BlockState)worldIn.getBlockState(target))) && worldIn.isInWorldBounds(pos)) {
            Gravisand entity = new Gravisand(worldIn, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, facing.getStepY());
            worldIn.setBlock(pos, state.getFluidState().createLegacyBlock(), 3);
            worldIn.addFreshEntity((Entity)entity);
            return true;
        }
        return false;
    }
}

