/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.entity;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.building.module.GlassItemFrameModule;

public class GlassItemFrame
extends ItemFrame
implements IEntityWithComplexSpawn {
    public static final EntityDataAccessor<Boolean> IS_SHINY = SynchedEntityData.defineId(GlassItemFrame.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final String TAG_SHINY = "isShiny";
    private static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.randomUUID(), "ItemFrame");
    private boolean didHackery = false;
    private int onSignRotation = 0;
    private SignAttachment attachment = SignAttachment.NOT_ATTACHED;

    public GlassItemFrame(EntityType<? extends GlassItemFrame> type, Level level) {
        super(type, level);
    }

    public GlassItemFrame(Level level, BlockPos pos, Direction direction) {
        super(GlassItemFrameModule.glassFrameEntity, level);
        this.pos = pos;
        this.setDirection(direction);
    }

    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack item = this.getItem();
        if (!(player.isShiftKeyDown() || item.isEmpty() || item.getItem() instanceof BannerItem)) {
            BlockState behindState;
            InteractionResult result;
            BlockPos behind = this.getBehindPos();
            BlockEntity tile = this.level().getBlockEntity(behind);
            if (tile != null && (result = (behindState = this.level().getBlockState(behind)).useWithoutItem(this.level(), player, new BlockHitResult(new Vec3(this.getX(), this.getY(), this.getZ()), this.direction, behind, true))).consumesAction()) {
                return result;
            }
        }
        InteractionResult result = super.interact(player, hand);
        this.updateIsOnSign();
        return result;
    }

    public void tick() {
        ItemStack stack;
        Item item;
        super.tick();
        boolean shouldUpdateMaps = GlassItemFrameModule.glassItemFramesUpdateMapsEveryTick;
        if (this.level().getGameTime() % 100L == 0L) {
            this.updateIsOnSign();
            shouldUpdateMaps = true;
        }
        if (!this.level().isClientSide && GlassItemFrameModule.glassItemFramesUpdateMaps && shouldUpdateMaps && (item = (stack = this.getItem()).getItem()) instanceof MapItem) {
            MapItem map = (MapItem)item;
            item = this.level();
            if (item instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)item;
                ItemStack clone = stack.copy();
                MapItemSavedData data = MapItem.getSavedData((ItemStack)clone, (Level)this.level());
                if (data != null && !data.locked) {
                    FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)sworld, (GameProfile)DUMMY_PROFILE);
                    clone.setEntityRepresentation(null);
                    fakePlayer.setPos(this.getX(), this.getY(), this.getZ());
                    fakePlayer.getInventory().setItem(0, clone);
                    map.update(this.level(), (Entity)fakePlayer, data);
                }
            }
        }
    }

    private void updateIsOnSign() {
        this.attachment = SignAttachment.NOT_ATTACHED;
        if (this.direction.getAxis() != Direction.Axis.Y) {
            Direction signDir;
            BlockState back = this.level().getBlockState(this.getBehindPos());
            boolean standing = back.is(BlockTags.STANDING_SIGNS);
            boolean hangingCeil = back.is(BlockTags.CEILING_HANGING_SIGNS);
            if (standing || hangingCeil) {
                this.onSignRotation = (Integer)back.getValue((Property)BlockStateProperties.ROTATION_16);
                double[] angles = new double[]{0.0, 0.0, 0.0, 180.0, -90.0, 90.0};
                double ourRotation = angles[this.getDirection().getOpposite().ordinal()];
                double signRotation = (double)((Integer)back.getValue((Property)BlockStateProperties.ROTATION_16)).intValue() / 16.0 * 360.0;
                if (signRotation > 180.0) {
                    signRotation -= 360.0;
                }
                double diff = ourRotation - signRotation;
                double absDiff = Math.abs(diff);
                if (diff < 0.0) {
                    absDiff -= 0.01;
                }
                if (absDiff < 45.0) {
                    this.attachment = standing ? SignAttachment.STANDING_IN_FRONT : SignAttachment.HANGING_IN_FRONT;
                } else if (absDiff >= 135.0 && absDiff < 225.0) {
                    this.attachment = standing ? SignAttachment.STANDING_BEHIND : SignAttachment.HANGING_BEHIND;
                }
                return;
            }
            if (back.is(BlockTags.WALL_SIGNS)) {
                Direction signDir2 = (Direction)back.getValue((Property)WallSignBlock.FACING);
                if (signDir2 == this.getDirection()) {
                    this.attachment = SignAttachment.WALL_SIGN;
                }
                return;
            }
            if (back.is(BlockTags.WALL_HANGING_SIGNS) && ((signDir = (Direction)back.getValue((Property)WallHangingSignBlock.FACING)) == this.getDirection() || signDir == this.getDirection().getOpposite())) {
                this.attachment = SignAttachment.HANGING_FROM_WALL;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_SHINY, (Object)false);
    }

    public boolean survives() {
        return this.isOnSign() || super.survives();
    }

    public BlockPos getBehindPos() {
        return this.pos.relative(this.direction.getOpposite());
    }

    public SignAttachment getSignAttachment() {
        return this.attachment;
    }

    public boolean isOnSign() {
        return this.getSignAttachment() != SignAttachment.NOT_ATTACHED;
    }

    public int getOnSignRotation() {
        return this.onSignRotation;
    }

    @NotNull
    public ItemEntity spawnAtLocation(@NotNull ItemStack stack, float offset) {
        if (stack.getItem() == Items.ITEM_FRAME && !this.didHackery) {
            stack = new ItemStack((ItemLike)this.getDroppedItem());
            this.didHackery = true;
        }
        return super.spawnAtLocation(stack, offset);
    }

    @NotNull
    public ItemStack getPickedResult(@NotNull HitResult target) {
        ItemStack held = this.getItem();
        return held.isEmpty() ? new ItemStack((ItemLike)this.getDroppedItem()) : held.copy();
    }

    private Item getDroppedItem() {
        return (Boolean)this.entityData.get(IS_SHINY) != false ? GlassItemFrameModule.glowingGlassFrame : GlassItemFrameModule.glassFrame;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.addAdditionalSaveData(cmp);
        cmp.putBoolean(TAG_SHINY, ((Boolean)this.entityData.get(IS_SHINY)).booleanValue());
    }

    public void readAdditionalSaveData(@NotNull CompoundTag cmp) {
        super.readAdditionalSaveData(cmp);
        this.entityData.set(IS_SHINY, (Object)cmp.getBoolean(TAG_SHINY));
    }

    public void writeSpawnData(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        registryFriendlyByteBuf.writeBlockPos(this.pos);
        registryFriendlyByteBuf.writeVarInt(this.direction.get3DDataValue());
    }

    public void readSpawnData(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
        this.pos = registryFriendlyByteBuf.readBlockPos();
        this.setDirection(Direction.from3DDataValue((int)registryFriendlyByteBuf.readVarInt()));
    }

    public static enum SignAttachment {
        NOT_ATTACHED,
        STANDING_IN_FRONT,
        STANDING_BEHIND,
        WALL_SIGN,
        HANGING_FROM_WALL,
        HANGING_IN_FRONT,
        HANGING_BEHIND;

    }
}

