/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.MapColor;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.block.MyaliteCrystalBlock;
import org.violetmoon.quark.content.world.gen.SpiralSpireGenerator;
import org.violetmoon.quark.content.world.module.CorundumModule;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.block.OldMaterials;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.CompoundBiomeConfig;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZGatherHints;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityTeleport;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world")
public class SpiralSpiresModule
extends ZetaModule {
    @Config
    public static DimensionConfig dimensions = DimensionConfig.end((boolean)false);
    @Config
    public static CompoundBiomeConfig biomes = CompoundBiomeConfig.fromBiomeReslocs((boolean)false, (String[])new String[]{"minecraft:end_highlands"});
    @Config
    public static int rarity = 200;
    @Config
    public static int radius = 15;
    @Config(flag="myalite_viaduct")
    public static boolean enableMyaliteViaducts = true;
    @Config
    @Config.Min(value=2.0)
    @Config.Max(value=1024.0)
    public static int myaliteConduitDistance = 24;
    @Config
    public static boolean renewableMyalite = true;
    public static ManualTrigger useViaductTrigger;
    @Hint
    public static Block dusky_myalite;
    public static Block myalite_crystal;

    @LoadEvent
    public final void register(ZRegister event) {
        BlockBehaviour.Properties props = OldMaterials.stone().mapColor(MapColor.TERRACOTTA_PURPLE).requiresCorrectToolForDrops().strength(1.5f, 6.0f);
        dusky_myalite = new ZetaBlock("dusky_myalite", (ZetaModule)this, props).setCreativeTab(CreativeModeTabs.BUILDING_BLOCKS, (ItemLike)Blocks.PURPUR_BLOCK, true);
        myalite_crystal = new MyaliteCrystalBlock(this);
        useViaductTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("use_viaduct");
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new SpiralSpireGenerator(dimensions), (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES, (int)0);
    }

    @LoadEvent
    public void addAdditionalHints(ZGatherHints event) {
        MutableComponent comp = Component.translatable((String)"quark.jei.hint.myalite_crystal_get");
        if (enableMyaliteViaducts) {
            comp = comp.append(" ").append((Component)Component.translatable((String)"quark.jei.hint.myalite_crystal_viaduct"));
        }
        if (renewableMyalite && Quark.ZETA.modules.isEnabled(CorundumModule.class)) {
            comp = comp.append(" ").append((Component)Component.translatable((String)"quark.jei.hint.myalite_crystal_grow"));
        }
        event.accept((ItemLike)myalite_crystal.asItem(), (Component)comp);
    }

    @PlayEvent
    public void onTeleport(ZEntityTeleport event) {
        BlockPos pos;
        if (!enableMyaliteViaducts) {
            return;
        }
        Entity entity = event.getEntity();
        Level world = entity.level();
        if (!world.isLoaded(pos = BlockPos.containing((double)event.getTargetX(), (double)event.getTargetY(), (double)event.getTargetZ()))) {
            return;
        }
        List<BlockPos> myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        if (myalite == null || myalite.isEmpty()) {
            pos = pos.below();
            myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        }
        if (myalite == null || myalite.isEmpty()) {
            pos = pos.relative(event.getEntity().getDirection());
            myalite = SpiralSpiresModule.getAdjacentMyalite(null, world, pos, null);
        }
        if (myalite != null && !myalite.isEmpty()) {
            BlockPos test;
            ArrayList<BlockPos> found;
            block12: {
                BlockPos prev;
                BlockPos cond = pos;
                found = new ArrayList<BlockPos>();
                int moves = 0;
                do {
                    prev = cond;
                    cond = myalite.get(world.random.nextInt(myalite.size()));
                    found.add(cond);
                    myalite = SpiralSpiresModule.getAdjacentMyalite(found, world, cond, null);
                    if (myalite != null && ++moves <= myaliteConduitDistance) continue;
                    return;
                } while (!myalite.isEmpty());
                test = cond.offset(cond.getX() - prev.getX(), cond.getY() - prev.getY(), cond.getZ() - prev.getZ());
                if (!world.getBlockState(test).isAir()) {
                    for (Direction d : Direction.values()) {
                        test = cond.relative(d);
                        if (!world.getBlockState(test).isAir()) continue;
                        if (d.getAxis() == Direction.Axis.Y) {
                            test = test.relative(d);
                        }
                        break block12;
                    }
                    return;
                }
            }
            event.setTargetX((double)test.getX() + 0.5);
            event.setTargetY((double)test.getY() + 0.5);
            event.setTargetZ((double)test.getZ() + 0.5);
            Entity entity2 = event.getEntity();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entity2;
                useViaductTrigger.trigger(sp);
            }
            if (world instanceof ServerLevel) {
                ServerLevel sworld = (ServerLevel)world;
                for (BlockPos f : found) {
                    sworld.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, myalite_crystal.defaultBlockState()), (double)f.getX() + 0.5, (double)f.getY() + 0.5, (double)f.getZ() + 0.5, 30, 0.25, 0.25, 0.25, 0.0);
                }
            }
        }
    }

    private static List<BlockPos> getAdjacentMyalite(List<BlockPos> found, Level world, BlockPos pos, Direction ignore) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>(6);
        ArrayList<BlockPos> collisions = new ArrayList<BlockPos>();
        for (Direction d : Direction.values()) {
            BlockPos off;
            if (d == ignore || world.getBlockState(off = pos.relative(d)).getBlock() != myalite_crystal) continue;
            if (found != null && found.contains(off)) {
                collisions.add(off);
                continue;
            }
            ret.add(off);
        }
        if (ret.isEmpty() && collisions.size() > 1) {
            return null;
        }
        return ret;
    }
}

