/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tweaks")
public class GoldToolsHaveFortuneModule
extends ZetaModule {
    private static final Tier[] TIERS = new Tier[]{Tiers.WOOD, Tiers.STONE, Tiers.IRON, Tiers.DIAMOND, Tiers.NETHERITE};
    @Config
    @Config.Min(value=0.0)
    public static int fortuneLevel = 2;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=4.0)
    public static int harvestLevel = 2;
    @Config
    public static boolean displayBakedEnchantmentsInTooltip = true;
    @Config
    public static boolean italicTooltip = true;
    @Config(description="Enchantments other than Gold's Fortune/Looting to bake into items. Format is \"item+enchant@level\", such as \"minecraft:stick+minecraft:sharpness@10\".")
    public static List<String> itemEnchantments = Lists.newArrayList();
    public static final Map<Item, Object2IntMap<ResourceKey<Enchantment>>> BUILTIN_ENCHANTMENTS = new HashMap<Item, Object2IntMap<ResourceKey<Enchantment>>>();
    @Hint(key="gold_tool_fortune", content={"fortuneLevel"})
    List<Item> gold_tools = Arrays.asList(Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_SWORD);
    @Hint(key="gold_tool_harvest_level", content={"harvestLevel"})
    List<Item> gold_tools_2 = this.gold_tools;
    private static boolean staticEnabled;

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        staticEnabled = this.isEnabled();
        BUILTIN_ENCHANTMENTS.clear();
        for (String configEntry : itemEnchantments) {
            ResourceLocation itemLocation;
            String[] configPair = configEntry.split("\\+");
            if (configPair.length != 2 || (itemLocation = ResourceLocation.tryParse((String)configPair[0])) == null) continue;
            Item item = (Item)BuiltInRegistries.ITEM.get(itemLocation);
            String[] enchantment = configPair[1].split("@");
            if (enchantment.length != 2) continue;
            ResourceKey enchantmentKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)enchantment[0]));
            Object2IntMap entry = BUILTIN_ENCHANTMENTS.computeIfAbsent(item, it -> new Object2IntArrayMap());
            entry.computeIfAbsent((Object)enchantmentKey, ench -> Integer.parseInt(enchantment[1]));
        }
        if (fortuneLevel > 0) {
            for (Item item : BuiltInRegistries.ITEM) {
                TieredItem tiered;
                if (!(item instanceof TieredItem) || (tiered = (TieredItem)item).getTier() != Tiers.GOLD) continue;
                Object2IntMap entry = BUILTIN_ENCHANTMENTS.computeIfAbsent(item, it -> new Object2IntArrayMap());
                entry.computeIfAbsent((Object)(item instanceof SwordItem ? Enchantments.LOOTING : Enchantments.FORTUNE), ench -> fortuneLevel);
            }
        }
    }

    public static boolean shouldOverrideCorrectTool(ItemStack stack, BlockState state) {
        TieredItem tiered;
        Item item;
        if (!staticEnabled || !((item = stack.getItem()) instanceof TieredItem) || (tiered = (TieredItem)item).getTier() != Tiers.GOLD) {
            return false;
        }
        Tool tool = (Tool)stack.get(DataComponents.TOOL);
        if (tool == null || state.is(TIERS[harvestLevel].getIncorrectBlocksForDrops())) {
            return false;
        }
        for (Tool.Rule rule : tool.rules()) {
            if (!rule.correctForDrops().isPresent() || !state.is(rule.blocks()) || !((Boolean)rule.correctForDrops().get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static int modifyFortuneLooting(Holder<Enchantment> holder, ItemStack stack, int original) {
        Object2IntMap<ResourceKey<Enchantment>> enchantmentList;
        if (!staticEnabled) {
            return original;
        }
        if (BUILTIN_ENCHANTMENTS.containsKey(stack.getItem()) && (enchantmentList = BUILTIN_ENCHANTMENTS.get(stack.getItem())).containsKey((Object)holder.getKey())) {
            int level = enchantmentList.getOrDefault((Object)holder.getKey(), 0);
            return Math.max(level, original);
        }
        return original;
    }

    public static ItemEnchantments modifyComponentEnchantLevel(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> registryLookup, ItemEnchantments enchantments) {
        if (!staticEnabled || !BUILTIN_ENCHANTMENTS.containsKey(stack.getItem())) {
            return enchantments;
        }
        Object2IntMap<ResourceKey<Enchantment>> builtInEnchantments = BUILTIN_ENCHANTMENTS.get(stack.getItem());
        ItemEnchantments.Mutable newEnchantments = new ItemEnchantments.Mutable(enchantments);
        for (ResourceKey enchantmentKey : builtInEnchantments.keySet()) {
            Holder.Reference holder = registryLookup.getOrThrow(enchantmentKey);
            newEnchantments.set((Holder)holder, Math.max(newEnchantments.getLevel((Holder)holder), builtInEnchantments.getOrDefault((Object)enchantmentKey, 0)));
        }
        return newEnchantments.toImmutable();
    }

    public static ItemStack createTooltipStack(ItemStack stack, DataComponentType<?> componentType, HolderLookup.Provider provider) {
        if (!staticEnabled || !displayBakedEnchantmentsInTooltip || componentType != DataComponents.ENCHANTMENTS) {
            return stack;
        }
        if (BUILTIN_ENCHANTMENTS.containsKey(stack.getItem())) {
            ItemStack copy = stack.copy();
            ItemEnchantments itemEnchantments = Optional.ofNullable((ItemEnchantments)copy.get(DataComponents.ENCHANTMENTS)).orElse(ItemEnchantments.EMPTY);
            Object2IntMap<ResourceKey<Enchantment>> builtInEnchantments = BUILTIN_ENCHANTMENTS.get(stack.getItem());
            ItemEnchantments.Mutable newEnchantments = new ItemEnchantments.Mutable(itemEnchantments);
            for (ResourceKey enchantmentKey : builtInEnchantments.keySet()) {
                Holder.Reference holder = provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantmentKey);
                newEnchantments.set((Holder)holder, Math.max(newEnchantments.getLevel((Holder)holder), builtInEnchantments.getOrDefault((Object)enchantmentKey, 0)));
            }
            copy.set(DataComponents.ENCHANTMENTS, (Object)newEnchantments.toImmutable());
            return copy;
        }
        return stack;
    }

    public static void modifyTooltip(ItemStack stack, List<Component> list, HolderLookup.Provider provider) {
        if (!displayBakedEnchantmentsInTooltip || !italicTooltip) {
            return;
        }
        if (BUILTIN_ENCHANTMENTS.containsKey(stack.getItem())) {
            Object2IntMap<ResourceKey<Enchantment>> builtInEnchantments = BUILTIN_ENCHANTMENTS.get(stack.getItem());
            for (ResourceKey enchantmentKey : builtInEnchantments.keySet()) {
                int level;
                Holder.Reference holder = provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(enchantmentKey);
                Component enchantmentEntry = Enchantment.getFullname((Holder)holder, (int)(level = builtInEnchantments.getInt((Object)enchantmentKey)));
                if (!list.contains(enchantmentEntry)) continue;
                int index = list.indexOf(enchantmentEntry);
                list.set(index, (Component)Enchantment.getFullname((Holder)holder, (int)level).copy().withStyle(ChatFormatting.ITALIC));
            }
        }
    }
}

