/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import java.util.List;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.client.tooltip.SeedPouchClientTooltipComponent;
import org.violetmoon.quark.content.tools.item.SeedPouchItem;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.load.ZTooltipComponents;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZItemEntityPickup;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class SeedPouchModule
extends ZetaModule {
    @Hint
    public static Item seed_pouch;
    public static final TagKey<Item> seedPouchHoldableTag;
    public static final TagKey<Item> seedPouchFertilizersTag;
    @Config
    public static int maxItems;
    @Config
    public static boolean showAllVariantsInCreative;
    @Config
    public static int shiftRange;
    @Config(description="Allow putting bone meal into the Seed Pouch (or anything else in the tag 'quark:seed_pouch_fertilizers')")
    public static boolean allowFertilizer;
    @Config
    public static int fertilizerShiftRange;

    @LoadEvent
    public final void register(ZRegister event) {
        seed_pouch = new SeedPouchItem(this);
    }

    @PlayEvent
    public void onItemPickup(ZItemEntityPickup event) {
        Player player = event.getPlayer();
        ItemStack toPickup = event.getItem().getItem();
        for (ItemStack pouch : List.of(player.getMainHandItem(), player.getOffhandItem())) {
            if (pouch.getItem() != seed_pouch || pouch.getCount() != 1 || !SeedPouchItem.mutateContents(pouch, contents -> !contents.isEmpty() && contents.absorb(toPickup)).booleanValue()) continue;
            Level level = player.level();
            if (!(level instanceof ServerLevel)) break;
            ServerLevel slevel = (ServerLevel)level;
            slevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BUNDLE_INSERT, SoundSource.PLAYERS, 0.2f, (slevel.random.nextFloat() - slevel.random.nextFloat()) * 1.4f + 2.0f);
            break;
        }
    }

    static {
        seedPouchHoldableTag = ItemTags.create((ResourceLocation)Quark.asResource("seed_pouch_holdable"));
        seedPouchFertilizersTag = ItemTags.create((ResourceLocation)Quark.asResource("seed_pouch_fertilizers"));
        maxItems = 640;
        showAllVariantsInCreative = true;
        shiftRange = 3;
        allowFertilizer = true;
        fertilizerShiftRange = 3;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends SeedPouchModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> ItemProperties.register((Item)seed_pouch, (ResourceLocation)Quark.asResource("pouch_items"), (ItemPropertyFunction)((ClampedItemPropertyFunction)(pouch, level, entityIn, pSeed) -> {
                int count;
                SeedPouchItem.PouchContents contents = SeedPouchItem.getContents(pouch);
                if (entityIn instanceof Player) {
                    Player player = (Player)entityIn;
                    if (contents.canFit(player.containerMenu.getCarried())) {
                        return 0.0f;
                    }
                }
                return (count = contents.getCount()) == 0 ? 0.0f : (float)count / (float)maxItems;
            })));
        }

        @LoadEvent
        public void registerClientTooltipComponentFactories(ZTooltipComponents event) {
            event.register(SeedPouchItem.Tooltip.class, t -> new SeedPouchClientTooltipComponent(t.stack()));
        }
    }
}

