/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.integration.lootr;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import noobanidus.mods.lootr.common.api.replacement.BlockReplacementMap;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.building.block.VariantChestBlock;
import org.violetmoon.quark.content.building.block.VariantTrappedChestBlock;
import org.violetmoon.quark.integration.lootr.ILootrIntegration;
import org.violetmoon.quark.integration.lootr.LootrVariantChestBlock;
import org.violetmoon.quark.integration.lootr.LootrVariantChestBlockEntity;
import org.violetmoon.quark.integration.lootr.LootrVariantTrappedChestBlock;
import org.violetmoon.quark.integration.lootr.LootrVariantTrappedChestBlockEntity;
import org.violetmoon.quark.integration.lootr.QuarkLootrBlockRepacementProvider;
import org.violetmoon.zeta.module.ZetaModule;

public class LootrIntegration
implements ILootrIntegration {
    public BlockEntityType<LootrVariantChestBlockEntity> chestTEType;
    public BlockEntityType<LootrVariantTrappedChestBlockEntity> trappedChestTEType;
    public final List<Block> lootrRegularChests = new ArrayList<Block>();
    public final List<Block> lootrTrappedChests = new ArrayList<Block>();

    @Override
    public BlockEntityType<? extends ChestBlockEntity> chestTE() {
        return this.chestTEType;
    }

    @Override
    public BlockEntityType<? extends ChestBlockEntity> trappedChestTE() {
        return this.trappedChestTEType;
    }

    @Override
    public void makeChestBlocks(ZetaModule module, String name, Block base, BooleanSupplier condition, Block quarkRegularChest, Block quarkTrappedChest) {
        VariantChestBlock lootrRegularChest = new LootrVariantChestBlock(name, module, () -> this.chestTEType, BlockPropertyUtil.copyPropertySafe(base)).setCondition(condition);
        this.lootrRegularChests.add((Block)lootrRegularChest);
        QuarkLootrBlockRepacementProvider.addMapping(quarkRegularChest, (Block)lootrRegularChest);
        VariantTrappedChestBlock lootrTrappedChest = new LootrVariantTrappedChestBlock(name, module, () -> this.trappedChestTEType, BlockPropertyUtil.copyPropertySafe(base)).setCondition(condition);
        this.lootrTrappedChests.add((Block)lootrTrappedChest);
        QuarkLootrBlockRepacementProvider.addMapping(quarkTrappedChest, (Block)lootrTrappedChest);
    }

    @Override
    @Nullable
    public Block lootrVariant(Block base) {
        return base;
    }

    public void populate(BlockReplacementMap map) {
    }

    @Override
    public void postRegister() {
        this.chestTEType = BlockEntityType.Builder.of(LootrVariantChestBlockEntity::new, (Block[])this.lootrRegularChests.toArray(new Block[0])).build(null);
        this.trappedChestTEType = BlockEntityType.Builder.of(LootrVariantTrappedChestBlockEntity::new, (Block[])this.lootrTrappedChests.toArray(new Block[0])).build(null);
        Quark.ZETA.registry.register(this.chestTEType, "lootr_variant_chest", Registries.BLOCK_ENTITY_TYPE);
        Quark.ZETA.registry.register(this.trappedChestTEType, "lootr_variant_trapped_chest", Registries.BLOCK_ENTITY_TYPE);
    }
}

