/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.QuarkSounds;
import org.violetmoon.quark.content.experimental.module.OverlayShaderModule;
import org.violetmoon.zeta.client.event.load.ZKeyMapping;
import org.violetmoon.zeta.client.event.play.ZEarlyRender;
import org.violetmoon.zeta.client.event.play.ZInput;
import org.violetmoon.zeta.client.event.play.ZScreenshot;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;

@ZetaLoadModule(category="client")
public class CameraModule
extends ZetaModule {
    @Config(description="Date format that will be displayed in screenshots. Must be a valid one (i.e. MM/dd/yyyy)")
    @Config.Condition(value=DatePredicate.class)
    private static String dateFormat = "MM/dd/yyyy";

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends CameraModule {
        private static final int RULER_COLOR = 0x33000000;
        private static final int RULERS = 4;
        private static final int BORERS = 6;
        private static final int OVERLAYS = 5;
        private static final ResourceLocation[] SHADERS = new ResourceLocation[]{null, Quark.asResource("shaders/post/grayscale.json"), Quark.asResource("shaders/post/sepia.json"), Quark.asResource("shaders/post/desaturate.json"), Quark.asResource("shaders/post/oversaturate.json"), Quark.asResource("shaders/post/cool.json"), Quark.asResource("shaders/post/warm.json"), Quark.asResource("shaders/post/conjugate.json"), Quark.asResource("shaders/post/redfocus.json"), Quark.asResource("shaders/post/greenfocus.json"), Quark.asResource("shaders/post/bluefocus.json"), Quark.asResource("shaders/post/yellowfocus.json"), ResourceLocation.withDefaultNamespace((String)"shaders/post/creeper.json"), Quark.asResource("shaders/post/enderman.json"), Quark.asResource("shaders/post/bits.json"), Quark.asResource("shaders/post/monochrome.json"), Quark.asResource("shaders/post/colorblind/deuteranopia.json"), Quark.asResource("shaders/post/colorblind/protanopia.json"), Quark.asResource("shaders/post/colorblind/tritanopia.json"), Quark.asResource("shaders/post/colorblind/achromatopsia.json")};
        private static KeyMapping cameraModeKey;
        private static int currentHeldItem;
        private static int currShader;
        private static int currRulers;
        private static int currBorders;
        private static int currOverlay;
        private static boolean queuedRefresh;
        private static boolean queueScreenshot;
        private static boolean screenshotting;
        private static boolean cameraMode;

        @LoadEvent
        public void registerKeybinds(ZKeyMapping event) {
            cameraModeKey = event.init("quark.keybind.camera_mode", "f12", "quark.gui.keygroup.misc");
        }

        @PlayEvent
        public void screenshotTaken(ZScreenshot event) {
            screenshotting = false;
        }

        @PlayEvent
        public void keystroke(ZInput.Key event) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && event.getAction() == 1) {
                if (cameraModeKey.isDown()) {
                    cameraMode = !cameraMode;
                    queuedRefresh = true;
                    return;
                }
                if (cameraMode && mc.screen == null) {
                    int key = event.getKey();
                    boolean affected = false;
                    boolean sneak = mc.player.isDiscrete();
                    switch (key) {
                        case 49: {
                            currShader = Client.cycle(currShader, SHADERS.length, sneak);
                            affected = true;
                            break;
                        }
                        case 50: {
                            currRulers = Client.cycle(currRulers, 4, sneak);
                            affected = true;
                            break;
                        }
                        case 51: {
                            currBorders = Client.cycle(currBorders, 6, sneak);
                            affected = true;
                            break;
                        }
                        case 52: {
                            currOverlay = Client.cycle(currOverlay, 5, sneak);
                            affected = true;
                            break;
                        }
                        case 53: {
                            if (!sneak) break;
                            currShader = 0;
                            currRulers = 0;
                            currBorders = 0;
                            currOverlay = 0;
                            affected = true;
                            break;
                        }
                        case 257: {
                            if (!queueScreenshot && !screenshotting) {
                                mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)QuarkSounds.ITEM_CAMERA_SHUTTER, (float)1.0f));
                            }
                            if (screenshotting && sneak) {
                                screenshotting = false;
                                queueScreenshot = false;
                                break;
                            }
                            queueScreenshot = true;
                        }
                    }
                    if (affected) {
                        queuedRefresh = true;
                        currentHeldItem = mc.player.getInventory().selected;
                    }
                }
            }
        }

        @PlayEvent
        public void renderTick(ZEarlyRender event) {
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player != null) {
                Inventory inventory = player.getInventory();
                if (currentHeldItem != -1 && inventory.selected != currentHeldItem) {
                    inventory.selected = currentHeldItem;
                    currentHeldItem = -1;
                }
            }
            if (mc.level == null) {
                cameraMode = false;
                queuedRefresh = true;
            } else if (queuedRefresh) {
                Client.refreshShader();
            }
            if (cameraMode && mc.screen == null) {
                if (queueScreenshot) {
                    screenshotting = true;
                }
                Client.renderCameraHUD(mc, event.guiGraphics());
                if (queueScreenshot) {
                    queueScreenshot = false;
                    Screenshot.grab((File)mc.gameDirectory, (RenderTarget)mc.getMainRenderTarget(), msg -> mc.execute(() -> mc.gui.getChat().addMessage(msg)));
                }
            }
        }

        private static void renderCameraHUD(Minecraft mc, GuiGraphics guiGraphics) {
            PoseStack matrix = guiGraphics.pose();
            Window mw = mc.getWindow();
            int twidth = mw.getGuiScaledWidth();
            int theight = mw.getGuiScaledHeight();
            int width = twidth;
            int height = theight;
            int paddingHoriz = 0;
            int paddingVert = 0;
            int paddingColor = -16777216;
            double targetAspect = -1.0;
            switch (currBorders) {
                case 1: {
                    targetAspect = 1.0;
                    break;
                }
                case 2: {
                    targetAspect = 1.3333333333333333;
                    break;
                }
                case 3: {
                    targetAspect = 1.7777777777777777;
                    break;
                }
                case 4: {
                    targetAspect = 2.3333333333333335;
                    break;
                }
                case 5: {
                    int border;
                    paddingHoriz = border = (int)(20.0 * ((double)(twidth * theight) / 518400.0));
                    paddingVert = border;
                    paddingColor = -1;
                }
            }
            if (targetAspect > 0.0) {
                double currAspect = (double)width / (double)height;
                if (currAspect > targetAspect) {
                    int desiredWidth = (int)((double)height * targetAspect);
                    paddingHoriz = (width - desiredWidth) / 2;
                } else if (currAspect < targetAspect) {
                    int desiredHeight = (int)((double)width / targetAspect);
                    paddingVert = (height - desiredHeight) / 2;
                }
            }
            width -= paddingHoriz * 2;
            height -= paddingVert * 2;
            if (paddingHoriz > 0) {
                guiGraphics.fill(0, 0, paddingHoriz, theight, paddingColor);
                guiGraphics.fill(twidth - paddingHoriz, 0, twidth, theight, paddingColor);
            }
            if (paddingVert > 0) {
                guiGraphics.fill(0, 0, twidth, paddingVert, paddingColor);
                guiGraphics.fill(0, theight - paddingVert, twidth, theight, paddingColor);
            }
            String overlayText = "";
            boolean overlayShadow = true;
            double overlayScale = 2.0;
            int overlayColor = -1;
            int overlayX = -1;
            int overlayY = -1;
            switch (currOverlay) {
                case 1: {
                    overlayText = new SimpleDateFormat(dateFormat).format(new Date(System.currentTimeMillis()));
                    overlayColor = 0xF77700;
                    break;
                }
                case 2: {
                    String worldName = "N/A";
                    if (mc.getSingleplayerServer() != null) {
                        worldName = mc.getSingleplayerServer().getWorldData().getLevelName();
                    } else if (mc.getCurrentServer() != null) {
                        worldName = mc.getCurrentServer().name;
                    }
                    overlayText = I18n.get((String)"quark.camera.greetings", (Object[])new Object[]{worldName});
                    overlayX = paddingHoriz + 20;
                    overlayY = paddingVert + 20;
                    overlayScale = 3.0;
                    overlayColor = 15684645;
                    break;
                }
                case 3: {
                    overlayText = mc.player.getGameProfile().getName();
                    overlayScale = 6.0;
                    overlayShadow = false;
                    overlayColor = 0x44000000;
                    break;
                }
                case 4: {
                    overlayText = mc.player.getMainHandItem().getHoverName().getString();
                    overlayX = twidth / 2 - mc.font.width(overlayText);
                    overlayY = paddingVert + 40;
                }
            }
            if (overlayX == -1) {
                overlayX = twidth - paddingHoriz - mc.font.width(overlayText) * (int)overlayScale - 40;
            }
            if (overlayY == -1) {
                overlayY = theight - paddingVert - 10 - 10 * (int)overlayScale;
            }
            if (!overlayText.isEmpty()) {
                matrix.pushPose();
                matrix.translate((float)overlayX, (float)overlayY, 0.0f);
                matrix.scale((float)overlayScale, (float)overlayScale, 1.0f);
                guiGraphics.drawString(mc.font, overlayText, 0, 0, overlayColor, overlayShadow);
                matrix.popPose();
            }
            if (!screenshotting) {
                matrix.pushPose();
                matrix.translate((float)paddingHoriz, (float)paddingVert, 0.0f);
                switch (currRulers) {
                    case 1: {
                        Client.vruler(guiGraphics, width / 3, height);
                        Client.vruler(guiGraphics, width / 3 * 2, height);
                        Client.hruler(guiGraphics, height / 3, width);
                        Client.hruler(guiGraphics, height / 3 * 2, width);
                        break;
                    }
                    case 2: {
                        double phi1 = 0.3831417624521073;
                        double phi2 = 0.6168582375478928;
                        Client.vruler(guiGraphics, (int)((double)width * phi1), height);
                        Client.vruler(guiGraphics, (int)((double)width * phi2), height);
                        Client.hruler(guiGraphics, (int)((double)height * phi1), width);
                        Client.hruler(guiGraphics, (int)((double)height * phi2), width);
                        break;
                    }
                    case 3: {
                        Client.vruler(guiGraphics, width / 2, height);
                        Client.hruler(guiGraphics, height / 2, width);
                    }
                }
                matrix.popPose();
                int left = 30;
                int top = theight - 65;
                ResourceLocation shader = SHADERS[currShader];
                Object text = "none";
                if (shader != null) {
                    text = shader.getPath().replaceAll(".+/(.+)\\.json", "$1");
                }
                text = String.valueOf(ChatFormatting.BOLD) + "[1] " + String.valueOf(ChatFormatting.RESET) + I18n.get((String)"quark.camera.filter", (Object[])new Object[0]) + String.valueOf(ChatFormatting.GOLD) + I18n.get((String)("quark.camera.filter." + (String)text), (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, (String)text, left, top, 0xFFFFFF, true);
                text = String.valueOf(ChatFormatting.BOLD) + "[2] " + String.valueOf(ChatFormatting.RESET) + I18n.get((String)"quark.camera.rulers", (Object[])new Object[0]) + String.valueOf(ChatFormatting.GOLD) + I18n.get((String)("quark.camera.rulers" + currRulers), (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, (String)text, left, top + 12, 0xFFFFFF, true);
                text = String.valueOf(ChatFormatting.BOLD) + "[3] " + String.valueOf(ChatFormatting.RESET) + I18n.get((String)"quark.camera.borders", (Object[])new Object[0]) + String.valueOf(ChatFormatting.GOLD) + I18n.get((String)("quark.camera.borders" + currBorders), (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, (String)text, left, top + 24, 0xFFFFFF, true);
                text = String.valueOf(ChatFormatting.BOLD) + "[4] " + String.valueOf(ChatFormatting.RESET) + I18n.get((String)"quark.camera.overlay", (Object[])new Object[0]) + String.valueOf(ChatFormatting.GOLD) + I18n.get((String)("quark.camera.overlay" + currOverlay), (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, (String)text, left, top + 36, 0xFFFFFF, true);
                text = String.valueOf(ChatFormatting.BOLD) + "[5] " + String.valueOf(ChatFormatting.RESET) + I18n.get((String)"quark.camera.reset", (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, (String)text, left, top + 48, 0xFFFFFF, true);
                text = String.valueOf(ChatFormatting.AQUA) + I18n.get((String)"quark.camera.header", (Object[])new Object[0]);
                guiGraphics.drawString(mc.font, (String)text, (float)(twidth / 2 - mc.font.width((String)text) / 2), 6.0f, 0xFFFFFF, true);
                text = I18n.get((String)"quark.camera.info", (Object[])new Object[]{Component.keybind((String)"quark.keybind.camera_mode").getString()});
                guiGraphics.drawString(mc.font, (String)text, (float)(twidth / 2 - mc.font.width((String)text) / 2), 16.0f, 0xFFFFFF, true);
                ResourceLocation CAMERA_TEXTURE = Quark.asResource("textures/misc/camera.png");
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blit(CAMERA_TEXTURE, left - 22, top + 18, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }

        private static void refreshShader() {
            if (queuedRefresh) {
                queuedRefresh = false;
            }
            Minecraft mc = Minecraft.getInstance();
            GameRenderer render = mc.gameRenderer;
            mc.options.hideGui = cameraMode;
            if (cameraMode) {
                ResourceLocation shader = SHADERS[currShader];
                if (shader != null) {
                    render.loadEffect(shader);
                    return;
                }
            } else {
                OverlayShaderModule shaderModule = (OverlayShaderModule)Quark.ZETA.modules.get(OverlayShaderModule.class);
                if (shaderModule != null && shaderModule.isEnabled()) {
                    for (ResourceLocation l : SHADERS) {
                        if (l == null || !l.getPath().contains(shaderModule.shader + ".json")) continue;
                        render.loadEffect(l);
                        return;
                    }
                }
            }
            render.checkEntityPostEffect(null);
        }

        private static void vruler(GuiGraphics guiGraphics, int x, int height) {
            guiGraphics.fill(x, 0, x + 1, height, 0x33000000);
        }

        private static void hruler(GuiGraphics guiGraphics, int y, int width) {
            guiGraphics.fill(0, y, width, y + 1, 0x33000000);
        }

        private static int cycle(int curr, int max, boolean neg) {
            int val = curr + (neg ? -1 : 1);
            if (val < 0) {
                val = max - 1;
            } else if (val >= max) {
                val = 0;
            }
            return val;
        }

        public static void queueRefresh() {
            queuedRefresh = true;
        }

        static {
            currentHeldItem = -1;
            currShader = 0;
            currRulers = 0;
            currBorders = 0;
            currOverlay = 0;
            queuedRefresh = true;
            queueScreenshot = false;
            screenshotting = false;
        }
    }

    private static class DatePredicate
    implements Predicate<Object> {
        private DatePredicate() {
        }

        @Override
        public boolean test(Object o) {
            if (o instanceof String) {
                String s = (String)o;
                try {
                    new SimpleDateFormat(s);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

