/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbilities;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.play.ZBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tweaks")
public class HoeHarvestingModule
extends ZetaModule {
    @Config
    @Config.Min(value=1.0)
    @Config.Max(value=5.0)
    public static int regularHoeRadius = 2;
    @Config
    @Config.Min(value=1.0)
    @Config.Max(value=5.0)
    public static int highTierHoeRadius = 3;
    @Hint(key="hoe_harvesting")
    public static TagKey<Block> hoe_harvestable = Quark.asTagKey(Registries.BLOCK, "hoe_harvestable");
    public static TagKey<Item> bigHarvestingHoesTag;

    public static int getRange(ItemStack hoe) {
        if (!Quark.ZETA.modules.isEnabled(HoeHarvestingModule.class)) {
            return 1;
        }
        if (!HoeHarvestingModule.isHoe(hoe)) {
            return 1;
        }
        if (hoe.is(bigHarvestingHoesTag)) {
            return highTierHoeRadius;
        }
        return regularHoeRadius;
    }

    public static boolean isHoe(ItemStack itemStack) {
        return !itemStack.isEmpty() && (itemStack.getItem() instanceof HoeItem || itemStack.is(ItemTags.HOES) || itemStack.getItem().canPerformAction(itemStack, ItemAbilities.HOE_DIG));
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        bigHarvestingHoesTag = Quark.asTagKey(Registries.ITEM, "big_harvesting_hoes");
    }

    @PlayEvent
    public void onBlockBroken(ZBlock.Break event) {
        LevelAccessor world = event.getLevel();
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        Player player = event.getPlayer();
        BlockPos basePos = event.getPos();
        ItemStack stack = player.getMainHandItem();
        if (HoeHarvestingModule.isHoe(stack) && this.canHarvest(player, world, basePos, event.getState())) {
            boolean brokeNonInstant = false;
            int range = HoeHarvestingModule.getRange(stack);
            for (int i = 1 - range; i < range; ++i) {
                for (int k = 1 - range; k < range; ++k) {
                    BlockState state;
                    BlockPos pos;
                    if (i == 0 && k == 0 || !this.canHarvest(player, world, pos = basePos.offset(i, 0, k), state = world.getBlockState(pos))) continue;
                    Block block = state.getBlock();
                    if (state.getDestroySpeed((BlockGetter)world, pos) != 0.0f) {
                        brokeNonInstant = true;
                    }
                    block.playerWillDestroy(level, pos, state, player);
                    if (block.canHarvestBlock(state, (BlockGetter)world, pos, player)) {
                        block.playerDestroy(level, player, pos, state, world.getBlockEntity(pos), stack);
                    }
                    world.destroyBlock(pos, false);
                    world.levelEvent(2001, pos, Block.getId((BlockState)state));
                }
            }
            if (brokeNonInstant) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }

    private boolean canHarvest(Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        return HoeHarvestingModule.isHarvestableBlock(state);
    }

    public static boolean isHarvestableBlock(BlockState state) {
        boolean isHarvestable = state.is(hoe_harvestable);
        if (state.getBlock().equals(Blocks.WATER)) {
            isHarvestable = false;
        } else {
            Block block = state.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                isHarvestable = state.equals(crop.getStateForAge(crop.getMaxAge()));
            } else if (state.getBlock() instanceof CocoaBlock) {
                isHarvestable = (Integer)state.getValue((Property)CocoaBlock.AGE) == 2;
            } else if (state.getBlock() instanceof LeavesBlock && ((Boolean)state.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue()) {
                isHarvestable = false;
            }
        }
        return isHarvestable;
    }
}

