/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block.pipe;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.PipeBlockEntity;
import org.violetmoon.quark.addons.oddities.block.pipe.BasePipeBlock;
import org.violetmoon.quark.addons.oddities.module.PipesModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.MiscUtil;

public class CopperPipeBlock
extends BasePipeBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape CENTER_SHAPE = Shapes.box((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape DOWN_SHAPE = Shapes.box((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape UP_SHAPE = Shapes.box((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    private static final VoxelShape NORTH_SHAPE = Shapes.box((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape SOUTH_SHAPE = Shapes.box((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)1.0);
    private static final VoxelShape WEST_SHAPE = Shapes.box((double)0.0, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape EAST_SHAPE = Shapes.box((double)0.3125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
    private static final VoxelShape[] SIDE_BOXES = new VoxelShape[]{DOWN_SHAPE, UP_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, EAST_SHAPE};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[64];
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public CopperPipeBlock(@Nullable ZetaModule module) {
        super("pipe", SoundType.COPPER, module);
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (stack.is(Items.GLASS) && PipesModule.enableEncasedPipes) {
            BlockEntity blockEntity = worldIn.getBlockEntity(pos);
            if (blockEntity instanceof PipeBlockEntity) {
                PipeBlockEntity be = (PipeBlockEntity)blockEntity;
                CompoundTag cmp = be.saveWithoutMetadata((HolderLookup.Provider)worldIn.registryAccess());
                if (!worldIn.isClientSide) {
                    worldIn.removeBlockEntity(pos);
                    BlockState target = ((BasePipeBlock)PipesModule.encasedPipe).getTargetState((LevelAccessor)worldIn, pos);
                    worldIn.setBlock(pos, target, 3);
                    worldIn.updateNeighborsAt(pos, PipesModule.encasedPipe);
                    BlockEntity newBe = worldIn.getBlockEntity(pos);
                    if (newBe != null) {
                        newBe.loadWithComponents(cmp, (HolderLookup.Provider)worldIn.registryAccess());
                    }
                }
                SoundType type = Blocks.GLASS.defaultBlockState().getSoundType((LevelReader)worldIn, pos, (Entity)player);
                SoundEvent sound = type.getPlaceSound();
                worldIn.playSound(player, pos, sound, SoundSource.BLOCKS, (type.getVolume() + 1.0f) / 2.0f, type.getPitch() * 0.8f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    @Override
    public BlockState getDefaultPipeState() {
        return (BlockState)super.getDefaultPipeState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    boolean isPipeWaterlogged(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED);
    }

    @Override
    protected BlockState getTargetState(LevelAccessor level, BlockPos pos) {
        return (BlockState)super.getTargetState(level, pos).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return this.isPipeWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighbor, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        if (this.isPipeWaterlogged(state)) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighbor, level, pos, neighborPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        for (Direction dir : Direction.values()) {
            if (!((Boolean)state.getValue((Property)MiscUtil.directionProperty((Direction)dir))).booleanValue()) continue;
            index += 1 << dir.ordinal();
        }
        VoxelShape cached = SHAPE_CACHE[index];
        if (cached == null) {
            VoxelShape currShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                boolean connected = CopperPipeBlock.isConnected(state, dir);
                if (!connected) continue;
                currShape = Shapes.or((VoxelShape)currShape, (VoxelShape)SIDE_BOXES[dir.ordinal()]);
            }
            CopperPipeBlock.SHAPE_CACHE[index] = currShape;
            cached = currShape;
        }
        return cached;
    }
}

