/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.module;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.client.handler.ModelHandler;
import org.violetmoon.quark.content.mobs.client.render.entity.ForgottenRenderer;
import org.violetmoon.quark.content.mobs.entity.Forgotten;
import org.violetmoon.quark.content.mobs.item.ForgottenHatItem;
import org.violetmoon.zeta.advancement.modifier.MonsterHunterModifier;
import org.violetmoon.zeta.api.IAdvancementModifier;
import org.violetmoon.zeta.client.HumanoidArmorModelGetter;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.load.ZRegisterClientExtension;
import org.violetmoon.zeta.client.extensions.IZetaClientItemExtensions;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.bus.ZResult;
import org.violetmoon.zeta.event.load.ZEntityAttributeCreation;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.living.ZMobSpawnEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="mobs")
public class ForgottenModule
extends ZetaModule {
    public static EntityType<Forgotten> forgottenType;
    @Hint
    public static Item forgotten_hat;
    @Config(description="This is the probability of a Skeleton that spawns under the height threshold being replaced with a Forgotten.")
    public double forgottenSpawnRate = 0.05;
    @Config
    public int maxHeightForSpawn = 0;

    @LoadEvent
    public final void register(ZRegister event) {
        forgotten_hat = new ForgottenHatItem(this);
        forgottenType = EntityType.Builder.of(Forgotten::new, (MobCategory)MobCategory.MONSTER).sized(0.7f, 2.4f).clientTrackingRange(8).build("forgotten");
        Quark.ZETA.registry.register(forgottenType, "forgotten", Registries.ENTITY_TYPE);
        Quark.ZETA.entitySpawn.addEgg(forgottenType, 9868423, 0x3A3330, (ZetaModule)this, BooleanSuppliers.TRUE);
        event.getAdvancementModifierRegistry().addModifier((IAdvancementModifier)new MonsterHunterModifier((ZetaModule)this, (Set)ImmutableSet.of(forgottenType)));
    }

    @LoadEvent
    public final void entityAttrs(ZEntityAttributeCreation e) {
        e.put(forgottenType, Forgotten.registerAttributes().build());
    }

    @PlayEvent
    public void onSkeletonSpawn(ZMobSpawnEvent.CheckSpawn.Lowest event) {
        if (event.getSpawnType() == MobSpawnType.SPAWNER) {
            return;
        }
        if (event.getEntity().isPassenger()) {
            return;
        }
        Mob entity = event.getEntity();
        ZResult result = event.getResult() ? ZResult.ALLOW : ZResult.DENY;
        ServerLevelAccessor world = event.getLevel();
        if (entity.getType() == EntityType.SKELETON && entity instanceof Mob) {
            Mob mob = entity;
            if (result != ZResult.DENY && entity.getY() < (double)this.maxHeightForSpawn && world.getRandom().nextDouble() < this.forgottenSpawnRate && (result == ZResult.ALLOW || mob.checkSpawnRules((LevelAccessor)world, event.getSpawnType()) && mob.checkSpawnObstruction((LevelReader)world))) {
                Forgotten forgotten = new Forgotten(forgottenType, entity.level());
                Vec3 epos = entity.position();
                forgotten.absMoveTo(epos.x, epos.y, epos.z, entity.getYRot(), entity.getXRot());
                forgotten.prepareEquipment(event.getLevel().registryAccess(), event.getLevel().getCurrentDifficultyAt(entity.getOnPos()));
                BlockPos pos = BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ());
                FinalizeSpawnEvent newEvent = new FinalizeSpawnEvent((Mob)forgotten, world, event.getX(), event.getY(), event.getZ(), world.getCurrentDifficultyAt(pos), event.getSpawnType(), null, event.getSpawner());
                NeoForge.EVENT_BUS.post((Event)newEvent);
                if (!newEvent.isCanceled()) {
                    world.addFreshEntity((Entity)forgotten);
                    event.setResult(ZResult.DENY);
                }
            }
        }
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends ForgottenModule {
        @LoadEvent
        public final void clientSetup(ZClientSetup event) {
            event.enqueueWork(() -> EntityRenderers.register((EntityType)forgottenType, ForgottenRenderer::new));
        }

        @LoadEvent
        public void setItemExtensions(ZRegisterClientExtension event) {
            event.registerItem(new IZetaClientItemExtensions(this){

                public HumanoidArmorModelGetter getHumanoidArmorModel() {
                    return (living, stack, slot, original) -> ModelHandler.armorModel(ModelHandler.forgotten_hat, slot);
                }
            }, forgotten_hat);
        }
    }
}

