/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.inventory.BackpackContainer;
import org.violetmoon.quark.addons.oddities.inventory.BackpackMenu;
import org.violetmoon.quark.addons.oddities.module.BackpackModule;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.item.IZetaItem;
import org.violetmoon.zeta.item.ext.IZetaItemExtensions;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class BackpackItem
extends ArmorItem
implements IZetaItem,
IZetaItemExtensions,
MenuProvider {
    private static final ResourceLocation WORN_TEXTURE = Quark.asResource("textures/misc/backpack_worn.png");
    private static final ResourceLocation WORN_OVERLAY_TEXTURE = Quark.asResource("textures/misc/backpack_worn_overlay.png");
    public static final ArmorMaterial BACKPACK_MATERIAL = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), points -> {
        points.put(ArmorItem.Type.BOOTS, 0);
        points.put(ArmorItem.Type.LEGGINGS, 0);
        points.put(ArmorItem.Type.CHESTPLATE, 0);
        points.put(ArmorItem.Type.HELMET, 0);
        points.put(ArmorItem.Type.BODY, 0);
    }), 0, SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.LEATHER}), List.of(new ArmorMaterial.Layer(Quark.asResource("backpack"), "", true), new ArmorMaterial.Layer(Quark.asResource("backpack"), "_overlay", false)), 0.0f, 0.0f);
    @Nullable
    private final ZetaModule module;

    public BackpackItem(@Nullable ZetaModule module) {
        super(Holder.direct((Object)BACKPACK_MATERIAL), ArmorItem.Type.CHESTPLATE, new Item.Properties().stacksTo(1).durability(0).rarity(Rarity.RARE).component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false)).attributes(BackpackItem.createAttributes()));
        this.module = module;
        if (module == null) {
            return;
        }
        module.zeta().registry.register((Object)BACKPACK_MATERIAL, "backpack", Registries.ARMOR_MATERIAL);
        module.zeta().registry.registerItem(this.getItem(), "backpack");
        CreativeTabManager.addNextToItem((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this.getItem(), (ItemLike)Items.SADDLE, (boolean)true);
    }

    public ZetaModule getModule() {
        return this.module;
    }

    public IZetaItem setCondition(BooleanSupplier condition) {
        return this;
    }

    public boolean doesConditionApply() {
        return true;
    }

    public static boolean doesBackpackHaveItems(ItemStack stack) {
        if (!stack.is(BackpackModule.backpack) || !stack.has(DataComponents.CONTAINER)) {
            return false;
        }
        BackpackContainer backpackInv = new BackpackContainer(stack);
        return !backpackInv.isEmpty();
    }

    public boolean canEquipZeta(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return armorType == EquipmentSlot.CHEST;
    }

    public boolean isBookEnchantableZeta(ItemStack stack, ItemStack book) {
        return false;
    }

    public int getEnchantmentValueZeta(ItemStack stack) {
        return 0;
    }

    public <T extends LivingEntity> int damageItemZeta(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        return 0;
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return layer != null && layer.texture(innerModel).getPath().contains("overlay") ? WORN_OVERLAY_TEXTURE : WORN_TEXTURE;
    }

    public void inventoryTick(@NotNull ItemStack stack, Level worldIn, @NotNull Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        if (worldIn.isClientSide) {
            return;
        }
        HolderLookup.RegistryLookup enchantmentLookup = worldIn.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference bindingCurse = enchantmentLookup.getOrThrow(Enchantments.BINDING_CURSE);
        boolean canIgnoreEquip = BackpackModule.superOpMode || entityIn instanceof Player && ((player = (Player)entityIn).isCreative() || player.isSpectator());
        ItemEnchantments.Mutable enchants = new ItemEnchantments.Mutable((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY.withTooltip(false)));
        boolean armorChangePrevented = EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE);
        boolean changedEnchants = false;
        if (BackpackItem.doesBackpackHaveItems(stack)) {
            Player player2;
            if (BackpackModule.isEntityWearingBackpack(entityIn, stack)) {
                if (BackpackModule.itemsInBackpackTick) {
                    BackpackContainer container = new BackpackContainer(stack);
                    for (int i = 0; i < container.getContainerSize(); ++i) {
                        ItemStack inStack = container.getItem(i);
                        if (inStack.isEmpty()) continue;
                        inStack.getItem().inventoryTick(inStack, worldIn, entityIn, i, false);
                    }
                }
                if (!armorChangePrevented && !canIgnoreEquip) {
                    enchants.set((Holder)bindingCurse, 1);
                    changedEnchants = true;
                }
            } else if (!canIgnoreEquip) {
                stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
            } else if (!BackpackModule.superOpMode && entityIn instanceof Player && ((player2 = (Player)entityIn).isCreative() || player2.isSpectator())) {
                stack.set(DataComponents.LORE, (Object)ItemLore.EMPTY.withLineAdded((Component)Component.translatable((String)"item.quark.backpack.warning.line_1").withStyle(ChatFormatting.RED)).withLineAdded((Component)Component.translatable((String)"item.quark.backpack.warning.line_2")));
            }
        } else if (armorChangePrevented) {
            enchants.removeIf(ench -> ((Enchantment)ench.value()).effects().has(EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE));
            changedEnchants = true;
        }
        if ((!BackpackItem.doesBackpackHaveItems(stack) || BackpackModule.superOpMode || !canIgnoreEquip || BackpackModule.isEntityWearingBackpack(entityIn, stack)) && stack.has(DataComponents.LORE)) {
            stack.remove(DataComponents.LORE);
        }
        if (changedEnchants) {
            stack.set(DataComponents.ENCHANTMENTS, (Object)enchants.toImmutable().withTooltip(false));
        }
    }

    public boolean onEntityItemUpdateZeta(ItemStack stack, ItemEntity entityItem) {
        if (BackpackModule.superOpMode || entityItem.level().isClientSide) {
            return false;
        }
        Optional<IItemHandler> handlerOpt = Optional.ofNullable((IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM, null));
        if (handlerOpt.isEmpty()) {
            return false;
        }
        IItemHandler handler = handlerOpt.orElse((IItemHandler)new ItemStackHandler());
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            if (stackAt.isEmpty()) continue;
            ItemStack copy = stackAt.copy();
            Containers.dropItemStack((Level)entityItem.level(), (double)entityItem.getX(), (double)entityItem.getY(), (double)entityItem.getZ(), (ItemStack)copy);
        }
        ItemEnchantments enchantments = Optional.ofNullable((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)).orElse(ItemEnchantments.EMPTY);
        Holder.Reference binding_curse = entityItem.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.BINDING_CURSE);
        ItemEnchantments.Mutable replaceEnch = new ItemEnchantments.Mutable(enchantments);
        if (replaceEnch.keySet().contains(binding_curse)) {
            replaceEnch.set((Holder)binding_curse, 0);
            stack.set(DataComponents.ENCHANTMENTS, (Object)replaceEnch.toImmutable());
        }
        stack.remove(DataComponents.CONTAINER);
        return false;
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().build();
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new BackpackMenu(id, player);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }
}

