/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;

public class AbacusItem
extends ZetaItem {
    public static final String TAG_POS_X = "boundPosX";
    public static final String TAG_POS_Y = "boundPosY";
    public static final String TAG_POS_Z = "boundPosZ";
    public static int MAX_COUNT = 48;
    private static final int DEFAULT_Y = -999;

    public AbacusItem(ZetaModule module) {
        super("abacus", module, new Item.Properties().stacksTo(1));
        CreativeTabManager.addNextToItem((ResourceKey)CreativeModeTabs.TOOLS_AND_UTILITIES, (ItemLike)this, (ItemLike)Items.SPYGLASS, (boolean)true);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        BlockPos curr = AbacusItem.getBlockPos(stack);
        if (curr != null) {
            AbacusItem.setBlockPos(stack, null);
        } else {
            AbacusItem.setBlockPos(stack, context.getClickedPos());
        }
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide);
    }

    public static void setBlockPos(ItemStack stack, BlockPos pos) {
        if (pos == null) {
            stack.set(QuarkDataComponents.BOUNDS_POS, (Object)new BlockPos(0, -999, 0));
        } else {
            stack.set(QuarkDataComponents.BOUNDS_POS, (Object)pos);
        }
    }

    public static BlockPos getBlockPos(ItemStack stack) {
        if (stack.has(QuarkDataComponents.BOUNDS_POS)) {
            BlockPos pos = (BlockPos)stack.get(QuarkDataComponents.BOUNDS_POS);
            if (pos.getY() == -999) {
                return null;
            }
            return pos;
        }
        return null;
    }

    public static int getCount(ItemStack stack, BlockPos target, Level world) {
        BlockPos pos = AbacusItem.getBlockPos(stack);
        if (pos != null && !world.isEmptyBlock(target)) {
            return Mth.clamp((int)target.distManhattan((Vec3i)pos), (int)0, (int)MAX_COUNT);
        }
        return -1;
    }

    public static class Client {
        public static final ClampedItemPropertyFunction ITEM_PROPERTY_FUNCTION = (stack, level, entityIn, id) -> {
            int count = Client.getCount(stack, entityIn);
            if (count == -1) {
                return 1.0f;
            }
            return 0.01f * (float)count + 0.005f;
        };

        public static int getCount(ItemStack stack, LivingEntity entityIn) {
            HitResult result;
            int count = -1;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (entityIn == player && player != null && (result = mc.hitResult) instanceof BlockHitResult) {
                BlockPos target = ((BlockHitResult)result).getBlockPos();
                count = AbacusItem.getCount(stack, target, player.level());
            }
            return count;
        }
    }
}

