/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.automation.block;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.content.automation.module.IronRodModule;
import org.violetmoon.zeta.api.ICollateralMover;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class IronRodBlock
extends EndRodBlock
implements ICollateralMover,
IZetaBlock {
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");

    public IronRodBlock(ZetaModule module) {
        super(BlockBehaviour.Properties.of().mapColor(DyeColor.GRAY).strength(5.0f, 10.0f).sound(SoundType.METAL).noOcclusion().forceSolidOn());
        module.zeta().registry.registerBlock((Block)this, "iron_rod", true);
        CreativeTabManager.addToTab((ResourceKey)CreativeModeTabs.REDSTONE_BLOCKS, (ItemLike)this);
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.module = module;
    }

    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    public IronRodBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONNECTED});
    }

    public boolean isCollateralMover(Level world, BlockPos source, Direction moveDirection, BlockPos pos) {
        return moveDirection == world.getBlockState(pos).getValue((Property)FACING) && !world.getBlockState(pos.relative(moveDirection)).is(IronRodModule.ironRodImmuneTag);
    }

    public ICollateralMover.MoveResult getCollateralMovement(Level world, BlockPos source, Direction moveDirection, Direction side, BlockPos pos) {
        return side == moveDirection && !world.getBlockState(pos.relative(side)).is(IronRodModule.ironRodImmuneTag) ? ICollateralMover.MoveResult.BREAK : ICollateralMover.MoveResult.SKIP;
    }

    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
    }
}

