/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.recipe;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.content.tweaks.module.SlabsToBlocksModule;

public class SlabToBlockRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<?> SERIALIZER = new SimpleCraftingRecipeSerializer(SlabToBlockRecipe::new);
    private boolean locked = false;

    public SlabToBlockRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        if (this.locked) {
            return false;
        }
        Item target = null;
        boolean checked = false;
        boolean result = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (target != null) {
                if (checked) {
                    return false;
                }
                result = item == target && this.checkForOtherRecipes(input, level);
                checked = true;
                continue;
            }
            if (SlabsToBlocksModule.recipes.containsKey(item)) {
                target = item;
                continue;
            }
            return false;
        }
        return result;
    }

    private synchronized boolean checkForOtherRecipes(CraftingInput input, Level level) {
        this.locked = true;
        boolean ret = false;
        MinecraftServer server = level.getServer();
        if (server != null) {
            Optional optional = server.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, level);
            ret = optional.isEmpty();
        }
        this.locked = false;
        return ret;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        for (int i = 0; i < inv.size(); ++i) {
            Item item;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !SlabsToBlocksModule.recipes.containsKey(item = stack.getItem())) continue;
            return new ItemStack((ItemLike)SlabsToBlocksModule.recipes.get(item));
        }
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

