/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class FoxhoundPlaceToRestGoal
extends MoveToBlockGoal {
    private final Foxhound foxhound;
    private final Target target;

    public FoxhoundPlaceToRestGoal(Foxhound foxhound, double speed, Target target) {
        super((PathfinderMob)foxhound, speed, 8);
        this.foxhound = foxhound;
        this.target = target;
    }

    public double acceptedDistance() {
        return 0.85;
    }

    public boolean canUse() {
        return this.foxhound.isTame() && !this.foxhound.isOrderedToSit() && !this.foxhound.isResting() && super.canUse();
    }

    public void start() {
        super.start();
        this.foxhound.setInSittingPose(false);
    }

    protected int nextStartTick(PathfinderMob creature) {
        return 40;
    }

    public void stop() {
        super.stop();
        this.foxhound.setResting(false);
    }

    public void tick() {
        super.tick();
        this.foxhound.setInSittingPose(false);
        if (!this.isReachedTarget()) {
            this.foxhound.setResting(false);
        } else if (!this.foxhound.isResting() && this.foxhound.canRest()) {
            this.foxhound.setResting(true);
        }
    }

    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        return this.target.test(level, pos);
    }

    public static enum Target {
        LIT_FURNACE((level, pos) -> level.getBlockEntity(pos) instanceof FurnaceBlockEntity && level.getLightEmission(pos) > 2),
        FURNACE((level, pos) -> level.getBlockEntity(pos) instanceof FurnaceBlockEntity && level.getLightEmission(pos) <= 2),
        GLOWING((level, pos) -> level.getLightEmission(pos) > 2 && level.getBlockState(pos).getFluidState().isEmpty());

        private final BiFunction<LevelReader, BlockPos, Boolean> check;

        private Target(BiFunction<LevelReader, BlockPos, Boolean> check) {
            this.check = check;
        }

        public boolean test(LevelReader level, BlockPos pos) {
            return level.isEmptyBlock(pos.above()) && this.check.apply(level, pos) != false;
        }
    }
}

