/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class FoxhoundModel
extends AgeableListModel<Foxhound> {
    public final ModelPart head;
    public final ModelPart rightFrontLeg;
    public final ModelPart leftFrontLeg;
    public final ModelPart rightBackLeg;
    public final ModelPart leftBackLeg;
    public final ModelPart body;
    public final ModelPart snout;
    public final ModelPart rightEar;
    public final ModelPart leftEar;
    public final ModelPart tail;
    public final ModelPart fluff;
    private final ModelPart root;

    public FoxhoundModel(ModelPart root) {
        super(false, 5.0f, 2.5f);
        this.root = root;
        this.head = root.getChild("head");
        this.rightFrontLeg = root.getChild("rightFrontLeg");
        this.leftFrontLeg = root.getChild("leftFrontLeg");
        this.rightBackLeg = root.getChild("rightBackLeg");
        this.leftBackLeg = root.getChild("leftBackLeg");
        this.body = root.getChild("body");
        this.snout = this.head.getChild("snout");
        this.rightEar = this.head.getChild("rightEar");
        this.leftEar = this.head.getChild("leftEar");
        this.tail = this.body.getChild("tail");
        this.fluff = this.body.getChild("fluff");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        float zOff = 5.5f;
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -3.0f, -6.0f, 8.0f, 6.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.5f, (float)-5.5f, (float)0.0f, (float)1.0f, (float)0.0f));
        head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(0, 47).addBox(-4.0f, -5.0f, -5.0f, 2.0f, 2.0f, 3.0f, cubeDeformation), PartPose.ZERO);
        head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(10, 47).addBox(2.0f, -5.0f, -5.0f, 2.0f, 2.0f, 3.0f, cubeDeformation), PartPose.ZERO);
        head.addOrReplaceChild("snout", CubeListBuilder.create().texOffs(29, 18).addBox(-2.0f, 1.0f, -10.0f, 4.0f, 2.0f, 4.0f, cubeDeformation), PartPose.ZERO);
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 2).addBox(-4.0f, -12.0f, 0.0f, 8.0f, 12.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)6.5f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(36, 16).addBox(-2.0f, -4.0f, 0.0f, 4.0f, 5.0f, 10.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.5f, (float)-1.3089969f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("fluff", CubeListBuilder.create().texOffs(28, 0).addBox(-5.0f, 0.0f, -4.0f, 10.0f, 8.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("leftBackLeg", CubeListBuilder.create().texOffs(36, 32).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)3.0f, (float)12.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("rightBackLeg", CubeListBuilder.create().texOffs(24, 32).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)-3.0f, (float)12.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(0, 32).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)-2.0f, (float)12.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(12, 32).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 12.0f, 3.0f, cubeDeformation), PartPose.offsetAndRotation((float)2.0f, (float)12.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void prepareMobModel(Foxhound hound, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tail.xRot = hound.getRemainingPersistentAngerTime() > 0 ? -0.65449846f : -1.3089969f + Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.head.yRot = hound.getHeadRollAngle(partialTickTime) - hound.getBodyRollAngle(partialTickTime, 0.0f);
        this.head.xRot = 0.0f;
        this.body.yRot = hound.getBodyRollAngle(partialTickTime, -0.16f);
        this.tail.yRot = hound.getBodyRollAngle(partialTickTime, -0.2f);
        if (this.fluff.visible && hound.hasArmor()) {
            this.fluff.visible = false;
        } else if (!this.fluff.visible && !hound.hasArmor()) {
            this.fluff.visible = true;
        }
        if (hound.isResting()) {
            this.head.setPos(1.0f, 20.5f, -5.5f);
            this.setAngle(this.head, 0.0f, 0.7853982f, -0.04363323f);
            this.body.setPos(0.0f, 20.0f, 6.5f);
            this.setAngle(this.body, 1.5707964f, 0.0f, 1.5707964f);
            this.tail.setPos(0.0f, -1.0f, 1.0f);
            this.setAngle(this.tail, 2.5497515f, -0.22759093f, 0.0f);
            this.rightFrontLeg.setPos(0.0f, 18.0f, -3.5f);
            this.leftFrontLeg.setPos(2.0f, 21.0f, -4.5f);
            this.rightBackLeg.setPos(0.0f, 22.0f, 5.5f);
            this.leftBackLeg.setPos(3.0f, 20.0f, 4.5f);
            this.setAngle(this.rightFrontLeg, 0.21816616f, 0.43633232f, 1.3089969f);
            this.setAngle(this.leftFrontLeg, 0.0f, 0.0f, 1.3962634f);
            this.setAngle(this.rightBackLeg, -1.0471976f, -0.08726646f, 1.4835298f);
            this.setAngle(this.leftBackLeg, -0.7853982f, 0.0f, 1.2217305f);
        } else if (hound.isInSittingPose()) {
            this.head.setPos(0.0f, 12.0f, -3.5f);
            this.body.setPos(0.0f, 23.0f, 1.5f);
            this.setAngle(this.body, 0.7853982f, this.body.yRot, 0.0f);
            this.tail.setPos(0.0f, 0.0f, 2.0f);
            this.setAngle(this.tail, -1.1f, -0.0f, 0.0f);
            this.rightFrontLeg.setPos(-2.0f, 12.0f, -4.25f);
            this.leftFrontLeg.setPos(2.0f, 12.0f, -4.25f);
            this.rightBackLeg.setPos(-3.0f, 21.0f, 4.5f);
            this.leftBackLeg.setPos(3.0f, 21.0f, 4.5f);
            this.setAngle(this.rightFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setAngle(this.leftFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setAngle(this.rightBackLeg, -1.3089969f, 0.3926991f, 0.0f);
            this.setAngle(this.leftBackLeg, -1.3089969f, -0.3926991f, 0.0f);
        } else {
            this.head.setPos(0.0f, 14.5f, -5.5f);
            this.body.setPos(0.0f, 17.0f, 6.5f);
            this.setAngle(this.body, 1.5707964f, this.body.yRot, 0.0f);
            this.tail.setPos(0.0f, 0.0f, 1.5f);
            this.rightFrontLeg.setPos(-2.0f, 12.0f, -3.5f);
            this.leftFrontLeg.setPos(2.0f, 12.0f, -3.5f);
            this.rightBackLeg.setPos(-3.0f, 12.0f, 4.0f);
            this.leftBackLeg.setPos(3.0f, 12.0f, 4.0f);
            this.setAngle(this.rightFrontLeg, Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setAngle(this.leftFrontLeg, Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setAngle(this.rightBackLeg, Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
            this.setAngle(this.leftBackLeg, Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount, 0.0f, 0.0f);
        }
    }

    public void setupAnim(Foxhound entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isResting()) {
            this.head.yRot += netHeadYaw * ((float)Math.PI / 180);
            this.head.xRot += headPitch * ((float)Math.PI / 180);
        } else {
            this.head.yRot += Mth.cos((float)((float)entity.tickCount / 30.0f)) / 20.0f;
        }
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightBackLeg, (Object)this.leftBackLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg);
    }

    public void setAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

