/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.world.block.MyaliteBlock;
import org.violetmoon.quark.content.world.block.MyaliteColorLogic;
import org.violetmoon.quark.content.world.config.BigStoneClusterConfig;
import org.violetmoon.quark.content.world.config.StoneTypeConfig;
import org.violetmoon.quark.content.world.module.BigStoneClustersModule;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.block.ZetaBlockWrapper;
import org.violetmoon.zeta.client.event.load.ZAddBlockColorHandlers;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.loading.ZVillagerTrades;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;
import org.violetmoon.zeta.world.generator.OreGenerator;

@ZetaLoadModule(category="world")
public class NewStoneTypesModule
extends ZetaModule {
    @Config(flag="limestone")
    public static boolean enableLimestone = true;
    @Config(flag="jasper")
    public static boolean enableJasper = true;
    @Config(flag="shale")
    public static boolean enableShale = true;
    @Config(flag="myalite")
    public static boolean enableMyalite = true;
    public static boolean enabledWithLimestone;
    public static boolean enabledWithJasper;
    public static boolean enabledWithShale;
    public static boolean enabledWithMyalite;
    @Config
    public static StoneTypeConfig limestone;
    @Config
    public static StoneTypeConfig jasper;
    @Config
    public static StoneTypeConfig shale;
    @Config
    public static StoneTypeConfig myalite;
    @Hint(value="limestone")
    public static Block limestoneBlock;
    @Hint(value="jasper")
    public static Block jasperBlock;
    @Hint(value="shale")
    public static Block shaleBlock;
    @Hint(value="myalite")
    public static Block myaliteBlock;
    @Config
    public static boolean addNewStonesToMasonTrades;
    public static Map<Block, Block> polishedBlocks;
    private static Queue<Runnable> defers;

    @LoadEvent
    public final void register(ZRegister event) {
        limestoneBlock = NewStoneTypesModule.makeStone(event, this, "limestone", limestone, BigStoneClustersModule.limestone, () -> enableLimestone, MapColor.STONE);
        jasperBlock = NewStoneTypesModule.makeStone(event, this, "jasper", jasper, BigStoneClustersModule.jasper, () -> enableJasper, MapColor.TERRACOTTA_RED);
        shaleBlock = NewStoneTypesModule.makeStone(event, this, "shale", shale, BigStoneClustersModule.shale, () -> enableShale, MapColor.ICE);
        myaliteBlock = NewStoneTypesModule.makeStone(event, this, null, "myalite", myalite, BigStoneClustersModule.myalite, () -> enableMyalite, MapColor.COLOR_PURPLE, (ZetaBlock.Constructor<ZetaBlock>)((ZetaBlock.Constructor)MyaliteBlock::new));
    }

    public static Block makeStone(ZRegister event, ZetaModule module, String name, StoneTypeConfig config, BigStoneClusterConfig bigConfig, BooleanSupplier enabledCond, MapColor color) {
        return NewStoneTypesModule.makeStone(event, module, null, name, config, bigConfig, enabledCond, color, (ZetaBlock.Constructor<ZetaBlock>)((ZetaBlock.Constructor)ZetaBlock::new));
    }

    public static Block makeStone(ZRegister event, ZetaModule module, Block raw, String name, StoneTypeConfig config, BigStoneClusterConfig bigConfig, BooleanSupplier enabledCond, MapColor color, ZetaBlock.Constructor<ZetaBlock> constr) {
        IZetaBlock quarkBlock;
        BooleanSupplier trueEnabledCond = () -> (bigConfig == null || !bigConfig.enabled || !Quark.ZETA.modules.isEnabled(BigStoneClustersModule.class)) && enabledCond.getAsBoolean();
        boolean isVanilla = raw != null;
        BlockBehaviour.Properties props = isVanilla ? BlockPropertyUtil.copyPropertySafe(raw) : BlockBehaviour.Properties.of().mapColor(color).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f);
        CreativeTabManager.startChain((ResourceKey)CreativeModeTabs.BUILDING_BLOCKS, (boolean)false, (boolean)true, (ItemLike)Blocks.DEEPSLATE);
        Block normal = isVanilla ? raw : ((ZetaBlock)constr.make(name, module, props)).setCondition(enabledCond).setCreativeTab(CreativeModeTabs.BUILDING_BLOCKS, (ItemLike)Blocks.DEEPSLATE, true);
        ZetaBlock polished = ((ZetaBlock)constr.make("polished_" + name, module, props)).setCondition(enabledCond);
        polishedBlocks.put(normal, (Block)polished);
        if (isVanilla) {
            polished.setCreativeTab(CreativeModeTabs.BUILDING_BLOCKS, (ItemLike)raw, false);
        } else {
            polished.setCreativeTab(CreativeModeTabs.BUILDING_BLOCKS);
        }
        CreativeTabManager.endChain();
        event.getVariantRegistry().addSlabStairsWall((IZetaBlock)(normal instanceof IZetaBlock ? (quarkBlock = (IZetaBlock)normal) : new ZetaBlockWrapper(normal, module).setCondition(enabledCond)), CreativeModeTabs.BUILDING_BLOCKS);
        event.getVariantRegistry().addSlabAndStairs((IZetaBlock)polished, CreativeModeTabs.BUILDING_BLOCKS);
        if (!isVanilla) {
            ((IZetaBlock)normal).setCreativeTab(CreativeModeTabs.NATURAL_BLOCKS, (ItemLike)Blocks.PRISMARINE, true);
            defers.add(() -> {
                WorldGenHandler.addGenerator((ZetaModule)module, (Generator)new OreGenerator(config.dimensions, config.oregenLower, normal.defaultBlockState(), OreGenerator.ALL_DIMS_STONE_MATCHER, trueEnabledCond), (GenerationStep.Decoration)GenerationStep.Decoration.UNDERGROUND_ORES, (int)1);
                WorldGenHandler.addGenerator((ZetaModule)module, (Generator)new OreGenerator(config.dimensions, config.oregenUpper, normal.defaultBlockState(), OreGenerator.ALL_DIMS_STONE_MATCHER, trueEnabledCond), (GenerationStep.Decoration)GenerationStep.Decoration.UNDERGROUND_ORES, (int)1);
            });
        }
        return isVanilla ? polished : normal;
    }

    @PlayEvent
    public void onTradesLoaded(ZVillagerTrades event) {
        if (event.getType() == VillagerProfession.MASON && addNewStonesToMasonTrades) {
            if (enableLimestone) {
                this.addStoneTrade(event, limestoneBlock);
            }
            if (enableJasper) {
                this.addStoneTrade(event, jasperBlock);
            }
            if (enableShale) {
                this.addStoneTrade(event, shaleBlock);
            }
        }
    }

    private void addStoneTrade(ZVillagerTrades event, Block block) {
        List journeymanListing = (List)event.getTrades().get(3);
        journeymanListing.add(new VillagerTrades.ItemsForEmeralds(block, 1, 4, 16, 10));
        journeymanListing.add(new VillagerTrades.EmeraldForItems((ItemLike)polishedBlocks.get(block), 16, 16, 20));
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        enabledWithLimestone = enableLimestone && this.isEnabled();
        enabledWithJasper = enableJasper && this.isEnabled();
        enabledWithShale = enableShale && this.isEnabled();
        enabledWithMyalite = enableMyalite && this.isEnabled();
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        while (!defers.isEmpty()) {
            defers.poll().run();
        }
    }

    static {
        limestone = new StoneTypeConfig();
        jasper = new StoneTypeConfig();
        shale = new StoneTypeConfig();
        myalite = new StoneTypeConfig(DimensionConfig.end((boolean)false));
        addNewStonesToMasonTrades = true;
        polishedBlocks = Maps.newHashMap();
        defers = new ArrayDeque<Runnable>();
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends NewStoneTypesModule {
        @LoadEvent
        public void blockColorProviders(ZAddBlockColorHandlers event) {
            event.registerNamed(this.zeta(), block -> MyaliteColorHandler.INSTANCE, new String[]{"myalite"});
        }

        @LoadEvent
        public void itemColorProviders(ZAddItemColorHandlers event) {
            event.registerNamed(this.zeta(), item -> MyaliteColorHandler.INSTANCE, new String[]{"myalite"});
        }

        private static class MyaliteColorHandler
        implements BlockColor,
        ItemColor {
            static final MyaliteColorHandler INSTANCE = new MyaliteColorHandler();

            private MyaliteColorHandler() {
            }

            public int getColor(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex) {
                return MyaliteColorLogic.getColor(pos);
            }

            public int getColor(ItemStack stack, int tintIndex) {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player == null) {
                    return MyaliteColorLogic.getColor(BlockPos.ZERO);
                }
                BlockPos pos = mc.player.blockPosition();
                HitResult res = mc.hitResult;
                if (res != null && res.getType() == HitResult.Type.BLOCK) {
                    pos = ((BlockHitResult)res).getBlockPos();
                }
                return MyaliteColorLogic.getColor(pos);
            }
        }
    }
}

