/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.violetmoon.quark.content.tools.module.BeaconRedirectionModule;

public class QuarkBeaconBlockEntityRenderer {
    public static boolean render(BeaconBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!BeaconRedirectionModule.staticEnabled) {
            return false;
        }
        long gameTime = tileEntityIn.getLevel().getGameTime();
        List list = tileEntityIn.getBeamSections();
        for (BeaconBlockEntity.BeaconBeamSection segment : list) {
            if (!(segment instanceof BeaconRedirectionModule.ExtendedBeamSegment)) {
                return false;
            }
            BeaconRedirectionModule.ExtendedBeamSegment extension = (BeaconRedirectionModule.ExtendedBeamSegment)segment;
            QuarkBeaconBlockEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, extension, partialTicks, gameTime);
        }
        return true;
    }

    private static void renderBeamSegment(PoseStack matrixStackIn, MultiBufferSource bufferIn, BeaconRedirectionModule.ExtendedBeamSegment segment, float partialTicks, long totalWorldTime) {
        QuarkBeaconBlockEntityRenderer.renderBeamSegment(matrixStackIn, bufferIn, BeaconRenderer.BEAM_LOCATION, segment, partialTicks, 1.0f, totalWorldTime, 0.2f, 0.25f);
    }

    public static void renderBeamSegment(PoseStack poseStack, MultiBufferSource bufferIn, ResourceLocation textureLocation, BeaconRedirectionModule.ExtendedBeamSegment segment, float partialTicks, float textureScale, long totalWorldTime, float beamRadius, float glowRadius) {
        int height = segment.getHeight();
        int colors = segment.getColor();
        int alpha = segment.alpha;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.translate((float)segment.offset.getX(), (float)segment.offset.getY(), (float)segment.offset.getZ());
        poseStack.mulPose(segment.dir.getRotation());
        float angle = (float)Math.floorMod(totalWorldTime, 40L) + partialTicks;
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(angle * 2.25f - 45.0f));
        float renderTime = -((float)totalWorldTime + partialTicks);
        float partAngle = Mth.frac((float)(renderTime * 0.2f - (float)Mth.floor((float)(angle * 0.1f))));
        float v2 = -1.0f + partAngle;
        float v1 = (float)height * textureScale * (0.5f / beamRadius) + v2;
        QuarkBeaconBlockEntityRenderer.renderPart(poseStack, bufferIn.getBuffer(RenderType.beaconBeam((ResourceLocation)textureLocation, (boolean)false)), FastColor.ARGB32.color((int)alpha, (int)colors), height, 0.0f, beamRadius, beamRadius, 0.0f, -beamRadius, 0.0f, 0.0f, -beamRadius, 0.0f, 1.0f, v1, v2);
        poseStack.popPose();
        v1 = (float)height * textureScale + v2;
        QuarkBeaconBlockEntityRenderer.renderPart(poseStack, bufferIn.getBuffer(RenderType.beaconBeam((ResourceLocation)textureLocation, (boolean)true)), FastColor.ARGB32.color((int)((int)(32.0f * ((float)alpha / 255.0f))), (int)colors), height, -glowRadius, -glowRadius, glowRadius, -glowRadius, -glowRadius, glowRadius, glowRadius, glowRadius, 0.0f, 1.0f, v1, v2);
        poseStack.popPose();
    }

    private static void renderPart(PoseStack poseStack, VertexConsumer bufferIn, int colors, int height, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, float u1, float u2, float v1, float v2) {
        PoseStack.Pose pose = poseStack.last();
        QuarkBeaconBlockEntityRenderer.addQuad(pose, bufferIn, colors, 0, height, x1, y1, x2, y2, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(pose, bufferIn, colors, 0, height, x4, y4, x3, y3, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(pose, bufferIn, colors, 0, height, x2, y2, x4, y4, u1, u2, v1, v2);
        QuarkBeaconBlockEntityRenderer.addQuad(pose, bufferIn, colors, 0, height, x3, y3, x1, y1, u1, u2, v1, v2);
    }

    private static void addQuad(PoseStack.Pose pose, VertexConsumer bufferIn, int colors, int yMin, int yMax, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        QuarkBeaconBlockEntityRenderer.addVertex(pose, bufferIn, colors, yMax, x1, z1, u2, v1);
        QuarkBeaconBlockEntityRenderer.addVertex(pose, bufferIn, colors, yMin, x1, z1, u2, v2);
        QuarkBeaconBlockEntityRenderer.addVertex(pose, bufferIn, colors, yMin, x2, z2, u1, v2);
        QuarkBeaconBlockEntityRenderer.addVertex(pose, bufferIn, colors, yMax, x2, z2, u1, v1);
    }

    private static void addVertex(PoseStack.Pose pose, VertexConsumer bufferIn, int colors, int y, float x, float z, float texU, float texV) {
        bufferIn.addVertex(pose, x, (float)y, z).setColor(colors).setUv(texU, texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

