/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorBaseContainerBlockEntity;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tweaks")
public class ShulkerPackingModule
extends ZetaModule {
    @Hint
    Item shulker_shell = Items.SHULKER_SHELL;

    @PlayEvent
    public void callFedEnd(ZRightClickBlock event) {
        BlockPos pos = event.getHitVec().getBlockPos();
        Player player = event.getPlayer();
        if (player.isShiftKeyDown()) {
            Level level;
            BlockState state;
            ItemStack mainHand = player.getMainHandItem();
            ItemStack offHand = player.getOffhandItem();
            if (mainHand.is(Items.SHULKER_SHELL) && offHand.is(Items.SHULKER_SHELL) && (state = (level = player.level()).getBlockState(pos)).is(Tags.Blocks.CHESTS) && !state.is(Blocks.ENDER_CHEST)) {
                Container container;
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide()));
                if (level.isClientSide()) {
                    return;
                }
                ItemStack newShulkerBox = new ItemStack((ItemLike)Blocks.SHULKER_BOX);
                ShulkerBoxBlockEntity shulkerBoxData = new ShulkerBoxBlockEntity(pos, Blocks.SHULKER_BOX.defaultBlockState());
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof Container && (container = (Container)be).getContainerSize() == shulkerBoxData.getContainerSize()) {
                    Component component;
                    Nameable nameable;
                    NonNullList items = NonNullList.create();
                    for (int i = 0; i < container.getContainerSize(); ++i) {
                        ItemStack inSlot = container.getItem(i);
                        if (!shulkerBoxData.canPlaceItemThroughFace(i, inSlot, null)) continue;
                        items.add(i, (Object)inSlot);
                        container.setItem(i, ItemStack.EMPTY);
                    }
                    if (be instanceof Nameable && (nameable = (Nameable)be).hasCustomName() && (component = nameable.getCustomName()) != null) {
                        ((AccessorBaseContainerBlockEntity)shulkerBoxData).setName(component);
                        newShulkerBox.set(DataComponents.CUSTOM_NAME, (Object)component);
                    }
                    level.destroyBlock(pos, false, (Entity)player);
                    level.playSound(null, pos, SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    player.awardStat(Stats.ITEM_USED.get((Object)Items.SHULKER_SHELL), 2);
                    if (!player.getAbilities().instabuild) {
                        mainHand.shrink(1);
                        offHand.shrink(1);
                    }
                    newShulkerBox.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)shulkerBoxData.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess())));
                    newShulkerBox.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)items));
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)newShulkerBox, (int)player.getInventory().selected);
                }
            }
        }
    }
}

