/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.mobs.ai;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.mobs.entity.Foxhound;

public class FindPlaceToSleepGoal
extends MoveToBlockGoal {
    private final Foxhound foxhound;
    private final Target target;
    private boolean hadSlept = false;

    public FindPlaceToSleepGoal(Foxhound foxhound, double speed, Target target) {
        super((PathfinderMob)foxhound, speed, 8);
        this.foxhound = foxhound;
        this.target = target;
    }

    public boolean canUse() {
        return this.foxhound.isTame() && !this.foxhound.isOrderedToSit() && super.canUse();
    }

    public boolean canContinueToUse() {
        return (!this.hadSlept || this.foxhound.isSleeping()) && super.canContinueToUse();
    }

    public void start() {
        super.start();
        this.hadSlept = false;
        this.foxhound.setOrderedToSit(false);
        this.foxhound.setInSittingPose(false);
    }

    public void stop() {
        super.stop();
        this.hadSlept = false;
        this.foxhound.setOrderedToSit(false);
        this.foxhound.setInSittingPose(false);
    }

    public void tick() {
        super.tick();
        Vec3 motion = this.foxhound.getDeltaMovement();
        if (this.isReachedTarget() && motion.horizontalDistance() <= 0.0 && this.target.test((LevelReader)this.foxhound.level(), this.foxhound.getOnPos()) && !this.foxhound.isOrderedToSit()) {
            this.foxhound.setInSittingPose(true);
            this.foxhound.setSleeping(true);
            this.hadSlept = true;
        }
    }

    protected boolean isValidTarget(@NotNull LevelReader world, @NotNull BlockPos pos) {
        return this.target.test(world, pos);
    }

    public static enum Target {
        LIT_FURNACE((level, pos) -> level.getBlockEntity(pos) instanceof FurnaceBlockEntity && level.getLightEmission(pos) > 2),
        FURNACE((level, pos) -> level.getBlockEntity(pos) instanceof FurnaceBlockEntity && level.getLightEmission(pos) <= 2),
        GLOWING((level, pos) -> level.getLightEmission(pos) > 2);

        private final BiFunction<LevelReader, BlockPos, Boolean> check;

        private Target(BiFunction<LevelReader, BlockPos, Boolean> check) {
            this.check = check;
        }

        public boolean test(LevelReader level, BlockPos pos) {
            return level.isEmptyBlock(pos.above()) && this.check.apply(level, pos) != false;
        }
    }
}

