/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class FoodTooltips {
    public static final ResourceLocation FOOD_EMPTY_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/food_empty_hunger.png");
    public static final ResourceLocation FOOD_HALF_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/food_half_hunger.png");
    public static final ResourceLocation FOOD_FULL_HUNGER_SPRITE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/food_full_hunger.png");
    public static final ResourceLocation FOOD_EMPTY_SPRITE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/food_empty.png");
    public static final ResourceLocation FOOD_HALF_SPRITE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/food_half.png");
    public static final ResourceLocation FOOD_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/food_full.png");

    private static boolean isPoison(FoodProperties food) {
        for (FoodProperties.PossibleEffect effect : food.effects()) {
            if (effect == null || ((MobEffect)effect.effect().getEffect().value()).getCategory() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static void makeTooltip(ZGatherTooltipComponents event, boolean showFood, boolean showSaturation) {
        FoodProperties food;
        ItemStack stack = event.getItemStack();
        if (stack.has(DataComponents.FOOD) && (food = (FoodProperties)stack.get(DataComponents.FOOD)) != null) {
            int pips = food.nutrition();
            if (pips == 0) {
                return;
            }
            int len = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
            int saturationSimplified = 0;
            float saturation = Math.min(20.0f, food.saturation() * (float)food.nutrition() * 2.0f);
            if (saturation >= 19.0f) {
                saturationSimplified = 5;
            } else if (saturation < 10.0f) {
                saturationSimplified = saturation >= 8.0f ? 1 : (saturation >= 6.0f ? 2 : (saturation >= 2.0f ? 3 : 4));
            }
            String prefix = FoodTooltips.isPoison(food) ? "quark.misc.bad_saturation" : "quark.misc.saturation";
            MutableComponent saturationText = Component.translatable((String)(prefix + saturationSimplified)).withStyle(ChatFormatting.GRAY);
            List tooltip = event.getTooltipElements();
            len *= 9;
            if (tooltip.isEmpty()) {
                if (showFood) {
                    tooltip.add(Either.right((Object)new FoodComponent(stack, len, 10)));
                }
                if (showSaturation) {
                    tooltip.add(Either.left((Object)saturationText));
                }
            } else {
                int i = 1;
                if (showFood) {
                    tooltip.add(i, Either.right((Object)new FoodComponent(stack, len, 10)));
                    ++i;
                }
                if (showSaturation) {
                    tooltip.add(i, Either.left((Object)saturationText));
                }
            }
        }
    }

    public record FoodComponent(ItemStack stack, int width, int height) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            FoodProperties food;
            PoseStack pose = guiGraphics.pose();
            Minecraft mc = Minecraft.getInstance();
            if (this.stack.has(DataComponents.FOOD) && (food = this.stack.getItem().getFoodProperties(this.stack, (LivingEntity)mc.player)) != null) {
                boolean compress;
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int pips = food.nutrition();
                if (pips == 0) {
                    return;
                }
                boolean poison = FoodTooltips.isPoison(food);
                int count = (int)Math.ceil((double)pips / (double)ImprovedTooltipsModule.foodDivisor);
                boolean fract = pips % 2 != 0;
                int renderCount = count;
                int y = tooltipY - 1;
                boolean bl = compress = count > ImprovedTooltipsModule.foodCompressionThreshold;
                if (compress) {
                    renderCount = 1;
                    if (fract) {
                        --count;
                    }
                }
                pose.pushPose();
                pose.translate(0.0f, 0.0f, 500.0f);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                for (int i = 0; i < renderCount; ++i) {
                    int x = tooltipX + i * 9 - 1;
                    if (poison) {
                        guiGraphics.blit(FOOD_EMPTY_HUNGER_SPRITE, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                    } else {
                        guiGraphics.blit(FOOD_EMPTY_SPRITE, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                    }
                    if (fract && i == renderCount - 1) {
                        if (poison) {
                            guiGraphics.blit(FOOD_HALF_HUNGER_SPRITE, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                            continue;
                        }
                        guiGraphics.blit(FOOD_HALF_SPRITE, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                        continue;
                    }
                    if (poison) {
                        guiGraphics.blit(FOOD_FULL_HUNGER_SPRITE, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                        continue;
                    }
                    guiGraphics.blit(FOOD_FULL_SPRITE, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
                }
                if (compress) {
                    guiGraphics.drawString(mc.font, "x" + count + (fract ? ".5" : ""), tooltipX + 10, y + 1, -10066330, true);
                }
                pose.popPose();
            }
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth(@NotNull Font font) {
            return this.width;
        }
    }
}

