/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.components.QuarkDataComponents;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.tools.item.AncientTomeItem;
import org.violetmoon.quark.content.tools.module.AncientTomesModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;
import org.violetmoon.zeta.module.IDisableable;

public class EnchantedBookTooltips {
    private static List<ItemStack> testItems = null;
    private static Multimap<Enchantment, ItemStack> additionalStacks = null;
    public static final String TABLE_ONLY_DISPLAY = "quark:only_show_table_enchantments";
    private static ItemStack BOOK;

    public static void reloaded() {
        additionalStacks = null;
        testItems = null;
    }

    public static void makeTooltip(ZGatherTooltipComponents event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.getItem() == Items.ENCHANTED_BOOK || stack.getItem() == AncientTomesModule.ancient_tome) {
            List tooltip = event.getTooltipElements();
            int tooltipIndex = 0;
            List<EnchantmentInstance> enchants = EnchantedBookTooltips.getEnchantedBookEnchantments(stack);
            block0: for (EnchantmentInstance ed : enchants) {
                Component match = stack.getItem() == Items.ENCHANTED_BOOK ? Enchantment.getFullname((Holder)ed.enchantment, (int)ed.level) : AncientTomeItem.getFullTooltipText((Holder<Enchantment>)ed.enchantment);
                while (tooltipIndex < tooltip.size()) {
                    Either elmAt = (Either)tooltip.get(tooltipIndex);
                    if (elmAt.left().isPresent() && ((FormattedText)elmAt.left().get()).equals((Object)match)) {
                        boolean tableOnly = stack.has(QuarkDataComponents.TABLE_ONLY_ENCHANTS) && (Boolean)stack.get(QuarkDataComponents.TABLE_ONLY_ENCHANTS) != false;
                        List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment((Enchantment)ed.enchantment.value(), tableOnly);
                        int itemCount = items.size();
                        int lines = (int)Math.ceil((double)itemCount / 10.0);
                        int len = 3 + Math.min(10, itemCount) * 9;
                        tooltip.add(tooltipIndex + 1, Either.right((Object)new EnchantedBookComponent(len, lines * 10, (Enchantment)ed.enchantment.value(), tableOnly)));
                        continue block0;
                    }
                    ++tooltipIndex;
                }
            }
        }
    }

    private static List<ItemStack> getItemsForEnchantment(Enchantment e, boolean onlyForTable) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : EnchantedBookTooltips.getTestItems()) {
            IDisableable disableable;
            Item item = stack.getItem();
            if (item instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled() || stack.isEmpty() || !e.canEnchant(stack) || !e.isPrimaryItem(stack) || !stack.isEnchantable() || Quark.ZETA.itemExtensions.get(stack).getEnchantmentValueZeta(stack) <= 0) continue;
            list.add(stack);
        }
        if (onlyForTable) {
            if (BOOK == null) {
                BOOK = new ItemStack((ItemLike)Items.BOOK);
            }
            list.add(BOOK);
        }
        if (EnchantedBookTooltips.getAdditionalStacks().containsKey((Object)e)) {
            list.addAll(EnchantedBookTooltips.getAdditionalStacks().get((Object)e));
        }
        return list;
    }

    private static List<EnchantmentInstance> getEnchantedBookEnchantments(ItemStack stack) {
        ItemEnchantments enchantments;
        if (stack.has(DataComponents.ENCHANTMENTS) && !((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)).isEmpty()) {
            enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        } else if (stack.has(DataComponents.STORED_ENCHANTMENTS) && !((ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)).isEmpty()) {
            enchantments = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS);
        } else {
            return List.of();
        }
        ArrayList<EnchantmentInstance> retList = new ArrayList<EnchantmentInstance>(enchantments.size());
        for (Holder enchantment : enchantments.keySet()) {
            if (enchantment == null) continue;
            int level = enchantments.getLevel(enchantment);
            retList.add(new EnchantmentInstance(enchantment, level));
        }
        return retList;
    }

    private static Multimap<Enchantment, ItemStack> getAdditionalStacks() {
        if (additionalStacks == null) {
            EnchantedBookTooltips.computeAdditionalStacks();
        }
        return additionalStacks;
    }

    public static List<ItemStack> getTestItems() {
        if (testItems == null) {
            EnchantedBookTooltips.computeTestItems();
        }
        return testItems;
    }

    private static void computeTestItems() {
        testItems = ImprovedTooltipsModule.enchantingStacks.stream().map(ResourceLocation::parse).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).filter(i -> i != Items.AIR).map(ItemStack::new).toList();
    }

    private static void computeAdditionalStacks() {
        additionalStacks = HashMultimap.create();
        for (String s : ImprovedTooltipsModule.enchantingAdditionalStacks) {
            if (!s.contains("=")) continue;
            String[] tokens = s.split("=");
            String left = tokens[0];
            String right = tokens[1];
            ((Registry)Quark.ZETA.hackilyGetCurrentLevelRegistryAccess().registry(Registries.ENCHANTMENT).get()).getOptional(ResourceLocation.parse((String)left)).ifPresent(ench -> {
                for (String itemId : right.split(",")) {
                    BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)itemId)).ifPresent(item -> additionalStacks.put(ench, (Object)new ItemStack((ItemLike)item)));
                }
            });
        }
    }

    public record EnchantedBookComponent(int width, int height, Enchantment enchantment, boolean tableOnly) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void renderImage(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)tooltipX, (float)tooltipY, 0.0f);
            pose.scale(0.5f, 0.5f, 1.0f);
            List<ItemStack> items = EnchantedBookTooltips.getItemsForEnchantment(this.enchantment, this.tableOnly);
            int drawn = 0;
            for (ItemStack testStack : items) {
                guiGraphics.renderItem(testStack, 6 + drawn % 10 * 18, drawn / 10 * 20);
                ++drawn;
            }
            pose.popPose();
            RenderSystem.applyModelViewMatrix();
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth(@NotNull Font font) {
            return this.width;
        }
    }
}

