/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class WoodPostBlock
extends ZetaBlock
implements SimpleWaterloggedBlock {
    private static final float START = 0.0f;
    private static final float END = 16.0f;
    private static final float LEFT_EDGE = 6.0f;
    private static final float RIGHT_EDGE = 10.0f;
    private static final VoxelShape CENTER_SHAPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape DOWN_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape UP_SHAPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape[] SIDE_BOXES = new VoxelShape[]{DOWN_SHAPE, UP_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, EAST_SHAPE};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[192];
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final EnumProperty<PostSideType>[] SIDES = new EnumProperty[]{EnumProperty.create((String)"connect_down", PostSideType.class), EnumProperty.create((String)"connect_up", PostSideType.class), EnumProperty.create((String)"connect_north", PostSideType.class), EnumProperty.create((String)"connect_south", PostSideType.class), EnumProperty.create((String)"connect_west", PostSideType.class), EnumProperty.create((String)"connect_east", PostSideType.class)};

    public WoodPostBlock(@Nullable ZetaModule module, Block parent, String prefix, SoundType sound) {
        super(Quark.ZETA.registryUtil.inherit(parent, s -> prefix + s.replace("_fence", "_post")), module, BlockPropertyUtil.copyPropertySafe(parent).sound(sound));
        BlockState state = (BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)Direction.Axis.Y);
        for (EnumProperty<PostSideType> prop : SIDES) {
            state = (BlockState)state.setValue(prop, (Comparable)((Object)PostSideType.NONE));
        }
        this.registerDefaultState(state);
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.setCreativeTab(CreativeModeTabs.BUILDING_BLOCKS, (ItemLike)parent, true);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        for (Direction dir : Direction.values()) {
            if (!((PostSideType)((Object)state.getValue(SIDES[dir.ordinal()]))).isSolid()) continue;
            index += 1 << dir.ordinal();
        }
        VoxelShape cached = SHAPE_CACHE[index += 64 * ((Direction.Axis)state.getValue(AXIS)).ordinal()];
        if (cached == null) {
            VoxelShape currShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                boolean connected = this.isConnected(state, dir);
                if (!connected) continue;
                currShape = Shapes.or((VoxelShape)currShape, (VoxelShape)SIDE_BOXES[dir.ordinal()]);
            }
            WoodPostBlock.SHAPE_CACHE[index] = currShape;
            cached = currShape;
        }
        return cached;
    }

    private boolean isConnected(BlockState state, Direction dir) {
        if (state.getValue(AXIS) == dir.getAxis()) {
            return true;
        }
        return ((PostSideType)((Object)state.getValue(SIDES[dir.ordinal()]))).isSolid();
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis = context.getClickedFace().getAxis();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER))).setValue(AXIS, (Comparable)axis);
        for (Direction d : Direction.values()) {
            if (axis == d.getAxis()) continue;
            state = (BlockState)state.setValue(SIDES[d.ordinal()], (Comparable)((Object)PostSideType.get((LevelAccessor)level, pos, d)));
        }
        return state;
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        state = (BlockState)state.setValue(SIDES[facing.ordinal()], (Comparable)((Object)PostSideType.get(level, pos, facing)));
        return super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, AXIS});
        for (EnumProperty<PostSideType> prop : SIDES) {
            builder.add(new Property[]{prop});
        }
    }

    public static enum PostSideType implements StringRepresentable
    {
        NONE("none"),
        CHAIN("chain"),
        OTHER_POST("other_post");

        private final String name;

        private PostSideType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public boolean isSolid() {
            return this != NONE;
        }

        private static PostSideType get(LevelAccessor world, BlockPos pos, Direction d) {
            BlockState sideState = world.getBlockState(pos.relative(d));
            if (sideState.getBlock() instanceof ChainBlock && sideState.getValue((Property)BlockStateProperties.AXIS) == d.getAxis() || d == Direction.DOWN && sideState.getBlock() instanceof LanternBlock && (Boolean)sideState.getValue((Property)LanternBlock.HANGING) != false || d == Direction.DOWN && sideState.getBlock() instanceof CeilingHangingSignBlock) {
                return CHAIN;
            }
            if (sideState.getBlock() instanceof WoodPostBlock && sideState.getValue(AXIS) == d.getAxis()) {
                return OTHER_POST;
            }
            return NONE;
        }
    }
}

