/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.building.block.VariantFurnaceBlock;
import org.violetmoon.zeta.module.ZetaModule;

public class SoulFurnaceBlock
extends VariantFurnaceBlock {
    public static final BooleanProperty SOUL = BooleanProperty.create((String)"soul");

    public SoulFurnaceBlock(String type, ZetaModule module, BlockBehaviour.Properties props) {
        super(type, module, props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)SOUL, (Comparable)Boolean.valueOf(false)));
    }

    public void animateTick(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && ((Boolean)state.getValue((Property)SOUL)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.1) {
                level.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            Direction.Axis direction$axis = direction.getAxis();
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
            double d6 = random.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            return;
        }
        super.animateTick(state, level, pos, random);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockPos down = blockpos.below();
        BlockState downState = iblockreader.getBlockState(down);
        return (BlockState)super.getStateForPlacement(context).setValue((Property)SOUL, (Comparable)Boolean.valueOf(downState.is(BlockTags.SOUL_FIRE_BASE_BLOCKS)));
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.setValue((Property)SOUL, (Comparable)Boolean.valueOf(facingState.is(BlockTags.SOUL_FIRE_BASE_BLOCKS)));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SOUL});
    }
}

