/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.quark.content.building.module.HedgesModule;
import org.violetmoon.quark.content.world.block.BlossomLeavesBlock;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.ZetaFenceBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.registry.IZetaBlockColorProvider;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class HedgeBlock
extends ZetaFenceBlock
implements IZetaBlock,
IZetaBlockColorProvider {
    private static final VoxelShape WOOD_SHAPE = HedgeBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0);
    private static final VoxelShape HEDGE_CENTER_SHAPE = HedgeBlock.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH_SHAPE = HedgeBlock.box((double)2.0, (double)1.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0);
    private static final VoxelShape SOUTH_SHAPE = HedgeBlock.box((double)2.0, (double)1.0, (double)14.0, (double)14.0, (double)16.0, (double)15.0);
    private static final VoxelShape EAST_SHAPE = HedgeBlock.box((double)14.0, (double)1.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    private static final VoxelShape WEST_SHAPE = HedgeBlock.box((double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0);
    private static final VoxelShape EXTEND_SHAPE = HedgeBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    private final Object2IntMap<BlockState> hedgeStateToIndex = new Object2IntOpenHashMap();
    private final VoxelShape[] hedgeShapes;
    public final BlockState leafState;
    public static final BooleanProperty EXTEND = BooleanProperty.create((String)"extend");

    public HedgeBlock(String regname, @Nullable ZetaModule module, Block fence, Block leaf) {
        super(regname, module, BlockPropertyUtil.copyPropertySafe(fence));
        this.leafState = leaf.defaultBlockState();
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)EXTEND, (Comparable)Boolean.valueOf(false)));
        this.hedgeShapes = this.cacheHedgeShapes((ImmutableList<BlockState>)this.stateDefinition.getPossibleStates());
        if (module == null) {
            return;
        }
        CreativeTabManager.addNextToItem((ResourceKey)CreativeModeTabs.NATURAL_BLOCKS, (ItemLike)this, (ItemLike)leaf, (boolean)false);
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
    }

    @Deprecated(forRemoval=true)
    public HedgeBlock(@Nullable ZetaModule module, Block fence, Block leaf) {
        this(HedgeBlock.legacyComputeRegistryName(leaf), module, fence, leaf);
    }

    @Deprecated(forRemoval=true)
    private static String legacyComputeRegistryName(Block leaf) {
        ResourceLocation leafRes = Quark.ZETA.registry.getRegistryName((Object)leaf, (Registry)BuiltInRegistries.BLOCK);
        if (leaf instanceof BlossomLeavesBlock) {
            return leafRes.getPath().replaceAll("_blossom_leaves", "") + "_blossom_hedge";
        }
        return leafRes.getPath().replaceAll("_leaves", "_hedge");
    }

    public BlockState getLeaf() {
        return this.leafState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.hedgeShapes[this.getHedgeAABBIndex(state)];
    }

    private VoxelShape[] cacheHedgeShapes(ImmutableList<BlockState> possibleStates) {
        VoxelShape[] shapes = new VoxelShape[possibleStates.size()];
        for (int i = 0; i < shapes.length; ++i) {
            BlockState state = (BlockState)possibleStates.get(i);
            int realIndex = this.getHedgeAABBIndex(state);
            VoxelShape finishedShape = Shapes.or((VoxelShape)((Boolean)state.getValue((Property)EXTEND) != false ? EXTEND_SHAPE : WOOD_SHAPE), (VoxelShape)HEDGE_CENTER_SHAPE);
            if (((Boolean)state.getValue((Property)FenceBlock.NORTH)).booleanValue()) {
                finishedShape = Shapes.or((VoxelShape)finishedShape, (VoxelShape)NORTH_SHAPE);
            }
            if (((Boolean)state.getValue((Property)FenceBlock.SOUTH)).booleanValue()) {
                finishedShape = Shapes.or((VoxelShape)finishedShape, (VoxelShape)SOUTH_SHAPE);
            }
            if (((Boolean)state.getValue((Property)FenceBlock.EAST)).booleanValue()) {
                finishedShape = Shapes.or((VoxelShape)finishedShape, (VoxelShape)EAST_SHAPE);
            }
            if (((Boolean)state.getValue((Property)FenceBlock.WEST)).booleanValue()) {
                finishedShape = Shapes.or((VoxelShape)finishedShape, (VoxelShape)WEST_SHAPE);
            }
            shapes[realIndex] = finishedShape;
        }
        return shapes;
    }

    protected int getHedgeAABBIndex(BlockState curr) {
        return this.hedgeStateToIndex.computeIntIfAbsent((Object)curr, state -> {
            int i = 0;
            if (((Boolean)state.getValue((Property)FenceBlock.NORTH)).booleanValue()) {
                i |= 1;
            }
            if (((Boolean)state.getValue((Property)FenceBlock.SOUTH)).booleanValue()) {
                i |= 2;
            }
            if (((Boolean)state.getValue((Property)FenceBlock.EAST)).booleanValue()) {
                i |= 4;
            }
            if (((Boolean)state.getValue((Property)FenceBlock.WEST)).booleanValue()) {
                i |= 8;
            }
            if (((Boolean)state.getValue((Property)EXTEND)).booleanValue()) {
                i |= 0x10;
            }
            return i;
        });
    }

    public boolean connectsTo(BlockState state, boolean isSideSolid, @NotNull Direction direction) {
        return state.is(HedgesModule.hedgesTag);
    }

    public TriState canSustainPlantZeta(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return facing == Direction.UP && (Boolean)state.getValue((Property)WATERLOGGED) == false ? TriState.TRUE : TriState.FALSE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        BlockPos down = blockpos.below();
        BlockState downState = iblockreader.getBlockState(down);
        return (BlockState)super.getStateForPlacement(context).setValue((Property)EXTEND, (Comparable)Boolean.valueOf(downState.getBlock() instanceof HedgeBlock));
    }

    @NotNull
    public BlockState updateShape(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.setValue((Property)EXTEND, (Comparable)Boolean.valueOf(facingState.getBlock() instanceof HedgeBlock));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{EXTEND});
    }

    @Nullable
    public String getBlockColorProviderName() {
        return "hedge";
    }

    @Nullable
    public String getItemColorProviderName() {
        return "hedge";
    }
}

