/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.base.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.jetbrains.annotations.NotNull;

public class QuarkArmorModel
extends HumanoidModel<LivingEntity> {
    protected final EquipmentSlot slot;

    public QuarkArmorModel(ModelPart part, EquipmentSlot slot) {
        super(part);
        this.slot = slot;
    }

    public static LayerDefinition createLayer(int textureWidth, int textureHeight, Consumer<PartDefinition> rootConsumer) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("hat", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.ZERO);
        root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.ZERO);
        rootConsumer.accept(root);
        return LayerDefinition.create((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    public void setupAnim(@NotNull LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!(entity instanceof ArmorStand)) {
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            return;
        }
        ArmorStand entityIn = (ArmorStand)entity;
        this.head.xRot = (float)Math.PI / 180 * entityIn.getHeadPose().getX();
        this.head.yRot = (float)Math.PI / 180 * entityIn.getHeadPose().getY();
        this.head.zRot = (float)Math.PI / 180 * entityIn.getHeadPose().getZ();
        this.head.setPos(0.0f, 1.0f, 0.0f);
        this.body.xRot = (float)Math.PI / 180 * entityIn.getBodyPose().getX();
        this.body.yRot = (float)Math.PI / 180 * entityIn.getBodyPose().getY();
        this.body.zRot = (float)Math.PI / 180 * entityIn.getBodyPose().getZ();
        this.leftArm.xRot = (float)Math.PI / 180 * entityIn.getLeftArmPose().getX();
        this.leftArm.yRot = (float)Math.PI / 180 * entityIn.getLeftArmPose().getY();
        this.leftArm.zRot = (float)Math.PI / 180 * entityIn.getLeftArmPose().getZ();
        this.rightArm.xRot = (float)Math.PI / 180 * entityIn.getRightArmPose().getX();
        this.rightArm.yRot = (float)Math.PI / 180 * entityIn.getRightArmPose().getY();
        this.rightArm.zRot = (float)Math.PI / 180 * entityIn.getRightArmPose().getZ();
        this.leftLeg.xRot = (float)Math.PI / 180 * entityIn.getLeftLegPose().getX();
        this.leftLeg.yRot = (float)Math.PI / 180 * entityIn.getLeftLegPose().getY();
        this.leftLeg.zRot = (float)Math.PI / 180 * entityIn.getLeftLegPose().getZ();
        this.leftLeg.setPos(1.9f, 11.0f, 0.0f);
        this.rightLeg.xRot = (float)Math.PI / 180 * entityIn.getRightLegPose().getX();
        this.rightLeg.yRot = (float)Math.PI / 180 * entityIn.getRightLegPose().getY();
        this.rightLeg.zRot = (float)Math.PI / 180 * entityIn.getRightLegPose().getZ();
        this.rightLeg.setPos(-1.9f, 11.0f, 0.0f);
        this.hat.copyFrom(this.head);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int light, int overlay, int color) {
        this.setPartVisibility(this.slot);
        super.renderToBuffer(poseStack, consumer, light, overlay, color);
    }

    private void setPartVisibility(EquipmentSlot slot) {
        this.setAllVisible(false);
        switch (slot) {
            case HEAD: {
                this.head.visible = true;
                this.hat.visible = true;
                break;
            }
            case CHEST: {
                this.body.visible = true;
                this.rightArm.visible = true;
                this.leftArm.visible = true;
                break;
            }
            case LEGS: {
                this.body.visible = true;
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                break;
            }
            case FEET: {
                this.rightLeg.visible = true;
                this.leftLeg.visible = true;
                break;
            }
        }
    }
}

