/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.gen;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.violetmoon.quark.content.world.module.ChorusVegetationModule;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.util.BooleanSuppliers;
import org.violetmoon.zeta.world.generator.multichunk.MultiChunkFeatureGenerator;

public class ChorusVegetationGenerator
extends MultiChunkFeatureGenerator {
    public ChorusVegetationGenerator() {
        super(DimensionConfig.end((boolean)false), BooleanSuppliers.TRUE, 2093L);
    }

    public int getFeatureRadius() {
        return ChorusVegetationModule.radius;
    }

    public BlockPos[] getSourcesInChunk(WorldGenRegion world, Random random, ChunkGenerator generator, BlockPos chunkCorner) {
        Holder b;
        if (!chunkCorner.closerThan(Vec3i.ZERO, 1050.0) && ChorusVegetationModule.rarity > 0 && random.nextInt(ChorusVegetationModule.rarity) == 0 && (b = this.getBiome((LevelAccessor)world, chunkCorner, true)).is(Biomes.END_HIGHLANDS.location())) {
            return new BlockPos[]{chunkCorner};
        }
        return new BlockPos[0];
    }

    public void generateChunkPart(BlockPos src, ChunkGenerator generator, Random rand, BlockPos pos, WorldGenRegion worldIn) {
        for (int i = 0; i < ChorusVegetationModule.chunkAttempts; ++i) {
            BlockState stateAt;
            BlockPos placePos = pos.offset(rand.nextInt(16), 100, rand.nextInt(16));
            Holder b = this.getBiome((LevelAccessor)worldIn, placePos, true);
            double chance = this.getChance((Holder<Biome>)b);
            double dist = (placePos.getX() - src.getX()) * (placePos.getX() - src.getX()) + (placePos.getZ() - src.getZ()) * (placePos.getZ() - src.getZ());
            int ditherStart = 6;
            if (dist > (double)(ditherStart *= ditherStart)) {
                chance *= 1.0 - Math.atan((dist - (double)ditherStart) / 50.0) / 1.5707963267948966;
            }
            if (!(chance > 0.0) || !(rand.nextDouble() < chance)) continue;
            while (placePos.getY() > 40 && (stateAt = worldIn.getBlockState(placePos)).getBlock() != Blocks.END_STONE) {
                placePos = placePos.below();
            }
            if (worldIn.getBlockState(placePos).getBlock() != Blocks.END_STONE || !worldIn.getBlockState(placePos.above()).isAir()) continue;
            Block block = rand.nextDouble() < 0.1 ? ChorusVegetationModule.chorus_twist : ChorusVegetationModule.chorus_weeds;
            worldIn.setBlock(placePos.above(), block.defaultBlockState(), 2);
        }
    }

    private double getChance(Holder<Biome> b) {
        if (b.is(Biomes.END_HIGHLANDS.location())) {
            return ChorusVegetationModule.highlandsChance;
        }
        if (b.is(Biomes.END_MIDLANDS.location())) {
            return ChorusVegetationModule.midlandsChance;
        }
        return ChorusVegetationModule.otherEndBiomesChance;
    }
}

