/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.building.block.StoolBlock;

public class Stool
extends Entity {
    public Stool(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void tick() {
        super.tick();
        List passengers = this.getPassengers();
        boolean dead = passengers.isEmpty();
        BlockPos pos = this.blockPosition();
        BlockState state = this.level().getBlockState(pos);
        if (!dead && !(state.getBlock() instanceof StoolBlock)) {
            PistonMovingBlockEntity pistonBE;
            PistonMovingBlockEntity piston = null;
            boolean didOffset = false;
            BlockEntity tile = this.level().getBlockEntity(pos);
            if (tile instanceof PistonMovingBlockEntity && (pistonBE = (PistonMovingBlockEntity)tile).getMovedState().getBlock() instanceof StoolBlock) {
                piston = pistonBE;
            } else {
                for (Direction d : Direction.values()) {
                    PistonMovingBlockEntity pistonBE2;
                    BlockPos offPos = pos.relative(d);
                    tile = this.level().getBlockEntity(offPos);
                    if (!(tile instanceof PistonMovingBlockEntity) || !((pistonBE2 = (PistonMovingBlockEntity)tile).getMovedState().getBlock() instanceof StoolBlock)) continue;
                    piston = pistonBE2;
                    break;
                }
            }
            if (piston != null) {
                Direction dir = piston.getMovementDirection();
                this.move(MoverType.PISTON, new Vec3((double)dir.getStepX() * 0.33, (double)dir.getStepY() * 0.33, (double)dir.getStepZ() * 0.33));
                didOffset = true;
            }
            boolean bl = dead = !didOffset;
        }
        if (dead && !this.level().isClientSide) {
            this.removeAfterChangingDimensions();
            if (state.getBlock() instanceof StoolBlock) {
                this.level().setBlockAndUpdate(pos, (BlockState)state.setValue((Property)StoolBlock.SAT_IN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).subtract(0.0, 0.5, 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
    }
}

